/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class SystemUtil {
    public static final String SPECIFICATION_NAME = "java.specification.name";
    public static final String VERSION = "java.version";
    public static final String SPECIFICATION_VERSION = "java.specification.version";
    public static final String VENDOR = "java.vendor";
    public static final String SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String VENDOR_URL = "java.vendor.url";
    public static final String HOME = "java.home";
    public static final String LIBRARY_PATH = "java.library.path";
    public static final String TMPDIR = "java.io.tmpdir";
    public static final String COMPILER = "java.compiler";
    public static final String EXT_DIRS = "java.ext.dirs";
    public static final String VM_NAME = "java.vm.name";
    public static final String VM_SPECIFICATION_NAME = "java.vm.specification.name";
    public static final String VM_VERSION = "java.vm.version";
    public static final String VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String VM_VENDEOR = "java.vm.vendor";
    public static final String VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String CLASS_VERSION = "java.class.version";
    public static final String CLASS_PATH = "java.class.path";
    public static final String OS_NAME = "os.name";
    public static final String OS_ARCH = "os.arch";
    public static final String OS_VERSION = "os.version";
    public static final String FILE_SEPRATOR = "file.separator";
    public static final String PATH_SEPRATOR = "path.separator";
    public static final String LINE_SEPRATOR = "line.separator";
    public static final String USER_NAME = "user.name";
    public static final String USER_HOME = "user.home";
    public static final String USER_DIR = "user.dir";

    public static String get(final String key, String defaultValue) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        String value = null;
        try {
            value = null == System.getSecurityManager() ? System.getProperty(key) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        catch (Exception e) {
            Log.warn(e, "Unable to retrieve a system property '{}'; default values will be used.", key);
        }
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public static String get(String key) {
        return SystemUtil.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = SystemUtil.get(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    public static long getInt(String key, int defaultValue) {
        return Conver.toInt(SystemUtil.get(key), defaultValue).intValue();
    }

    public static long getLong(String key, long defaultValue) {
        return Conver.toLong(SystemUtil.get(key), defaultValue);
    }

    public static Properties props() {
        Properties props = null;
        try {
            props = null == System.getSecurityManager() ? System.getProperties() : AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
        }
        catch (Exception e) {
            Log.warn(e, "Unable to retrieve a system propertys; default values will be used.", new Object[0]);
        }
        return props;
    }

    public static void main(String[] args) {
    }
}

