/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecureUtil {
    public static final String MD2 = "MD2";
    public static final String MD4 = "MD4";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String HMAC_SHA1 = "HmacSHA1";
    public static final String RIPEMD128 = "RIPEMD128";
    public static final String RIPEMD160 = "RIPEMD160";
    private static char[] base64EncodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] INV = new int[256];

    public static String encrypt(String source, String algorithmName, String charset) {
        return SecureUtil.encrypt(StrUtil.encode(source, charset), algorithmName);
    }

    public static String encrypt(byte[] bytes, String algorithmName) {
        return Conver.toHex(SecureUtil.encryptWithoutHex(bytes, algorithmName));
    }

    public static byte[] encryptWithoutHex(byte[] bytes, String algorithmName) {
        MessageDigest md = null;
        try {
            if (StrUtil.isBlank(algorithmName)) {
                algorithmName = MD5;
            }
            md = MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(StrUtil.format("No such algorithm name for: {}", algorithmName));
        }
        return md.digest(bytes);
    }

    public static String sha1(String source, String charset) {
        return SecureUtil.encrypt(source, SHA1, charset);
    }

    public static byte[] mac(String algorithm, byte[] key, byte[] data) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(e, "No such algorithm: {}", algorithm);
        }
        catch (InvalidKeyException e) {
            throw new UtilException(e, "Invalid key: {}", new Object[]{key});
        }
        return mac == null ? null : mac.doFinal(data);
    }

    public static byte[] sha1(byte[] key, byte[] data) {
        return SecureUtil.mac(HMAC_SHA1, key, data);
    }

    public static String sha1(String key, String data, String charset) {
        Charset charsetObj = Charset.forName(charset);
        byte[] bytes = SecureUtil.sha1(key.getBytes(charsetObj), data.getBytes(charsetObj));
        return SecureUtil.base64(bytes, charset);
    }

    public static String initMacKey(String algorithm, String charset) throws Exception {
        return SecureUtil.base64(KeyGenerator.getInstance(algorithm).generateKey().getEncoded(), charset);
    }

    public static String md5(byte[] source) {
        return SecureUtil.encrypt(source, MD5);
    }

    public static String md5(String source, String charset) {
        return SecureUtil.encrypt(source, MD5, charset);
    }

    public static byte[] base64(byte[] arr, boolean lineSep) {
        int len;
        int n = len = arr != null ? arr.length : 0;
        if (len == 0) {
            return new byte[0];
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (lineSep ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = (byte)base64EncodeTable[i >>> 18 & 0x3F];
            dest[d++] = (byte)base64EncodeTable[i >>> 12 & 0x3F];
            dest[d++] = (byte)base64EncodeTable[i >>> 6 & 0x3F];
            dest[d++] = (byte)base64EncodeTable[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= destlen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = (byte)base64EncodeTable[i >> 12];
            dest[destlen - 3] = (byte)base64EncodeTable[i >>> 6 & 0x3F];
            dest[destlen - 2] = left == 2 ? (int)base64EncodeTable[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }

    public static String base64(String source, String charset) {
        return new String(SecureUtil.base64(StrUtil.encode(source, charset), false), Charset.forName(charset));
    }

    public static String base64(byte[] source, String charset) {
        return new String(SecureUtil.base64(source, false), Charset.forName(charset));
    }

    public static String decodeBase64(String source, String charset) {
        return new String(SecureUtil.decodeBase64(StrUtil.encode(source, charset)), Charset.forName(charset));
    }

    public static byte[] decodeBase64(byte[] arr) {
        int length = arr.length;
        if (length == 0) {
            return new byte[0];
        }
        int sndx = 0;
        int endx = length - 1;
        int pad = arr[endx] == 61 ? (arr[endx - 1] == 61 ? 2 : 1) : 0;
        int cnt = endx - sndx + 1;
        int sepCnt = length > 76 ? (arr[76] == 13 ? cnt / 78 : 0) << 1 : 0;
        int len = ((cnt - sepCnt) * 6 >> 3) - pad;
        byte[] dest = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = INV[arr[sndx++]] << 18 | INV[arr[sndx++]] << 12 | INV[arr[sndx++]] << 6 | INV[arr[sndx++]];
            dest[d++] = (byte)(i >> 16);
            dest[d++] = (byte)(i >> 8);
            dest[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sndx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sndx <= endx - pad) {
                i |= INV[arr[sndx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dest[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dest;
    }

    static {
        Arrays.fill(INV, -1);
        int iS = base64EncodeTable.length;
        for (int i = 0; i < iS; ++i) {
            SecureUtil.INV[SecureUtil.base64EncodeTable[i]] = i;
        }
        SecureUtil.INV[61] = 0;
    }
}

