/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.BasicType;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public class ClassUtil {
    private static Logger log = Log.get();
    private static FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return ClassUtil.isClass(pathname.getName()) || pathname.isDirectory() || ClassUtil.isJarFile(pathname);
        }
    };

    private ClassUtil() {
    }

    public static Set<Class<?>> scanPackage() {
        return ClassUtil.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassUtil.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, final Class<? extends Annotation> annotationClass) {
        return ClassUtil.scanPackage(packageName, new ClassFilter(){

            @Override
            public boolean accept(Class<?> clazz) {
                return clazz.isAnnotationPresent(annotationClass);
            }
        });
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, final Class<?> superClass) {
        return ClassUtil.scanPackage(packageName, new ClassFilter(){

            @Override
            public boolean accept(Class<?> clazz) {
                return superClass.isAssignableFrom(clazz) && !superClass.equals(clazz);
            }
        });
    }

    public static Set<Class<?>> scanPackage(String packageName, ClassFilter classFilter) {
        if (StrUtil.isBlank(packageName)) {
            packageName = "";
        }
        log.debug("Scan classes from package [{}]...", (Object)packageName);
        packageName = ClassUtil.getWellFormedPackageName(packageName);
        HashSet classes = new HashSet();
        for (String classPath : ClassUtil.getClassPaths(packageName)) {
            log.debug("Scan classpath: [{}]", (Object)classPath);
            ClassUtil.fillClasses(classPath, packageName, classFilter, classes);
        }
        if (classes.isEmpty()) {
            for (String classPath : ClassUtil.getJavaClassPaths()) {
                log.debug("Scan java classpath: [{}]", (Object)classPath);
                ClassUtil.fillClasses(classPath, new File(classPath), packageName, classFilter, classes);
            }
        }
        return classes;
    }

    public static final Set<String> getMethods(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = clazz.getMethods()) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPaths("");
    }

    public static Set<String> getClassPaths(String packageName) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(StrUtil.format("Loading classPath [{}] error!", packagePath), e);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            paths.add(resources.nextElement().getPath());
        }
        return paths;
    }

    public static String[] getJavaClassPaths() {
        String[] classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        return classPaths;
    }

    public static Class<?> castToPrimitive(Class<?> clazz) {
        BasicType basicType;
        if (null == clazz || clazz.isPrimitive()) {
            return clazz;
        }
        try {
            basicType = BasicType.valueOf(clazz.getSimpleName().toUpperCase());
        }
        catch (Exception e) {
            return clazz;
        }
        switch (basicType) {
            case BYTE: {
                return Byte.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case INTEGER: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
        }
        return clazz;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassUtil.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T extends Serializable> T cloneObj(T obj) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            return (T)((Serializable)in.readObject());
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, isInitialized, ClassUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
        return clazz;
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    private static String getWellFormedPackageName(String packageName) {
        return packageName.lastIndexOf(".") != packageName.length() - 1 ? packageName + "." : packageName;
    }

    private static void fillClasses(String path, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        int index = path.lastIndexOf(".jar!");
        if (index != -1) {
            path = path.substring(0, index + ".jar".length());
            path = StrUtil.removePrefix(path, "file:");
            ClassUtil.processJarFile(new File(path), packageName, classFilter, classes);
        } else {
            ClassUtil.fillClasses(path, new File(path), packageName, classFilter, classes);
        }
    }

    private static void fillClasses(String classPath, File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (file.isDirectory()) {
            ClassUtil.processDirectory(classPath, file, packageName, classFilter, classes);
        } else if (ClassUtil.isClassFile(file)) {
            ClassUtil.processClassFile(classPath, file, packageName, classFilter, classes);
        } else if (ClassUtil.isJarFile(file)) {
            ClassUtil.processJarFile(file, packageName, classFilter, classes);
        }
    }

    private static void processDirectory(String classPath, File directory, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        for (File file : directory.listFiles(fileFilter)) {
            ClassUtil.fillClasses(classPath, file, packageName, classFilter, classes);
        }
    }

    private static void processClassFile(String classPath, File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (!classPath.endsWith(File.separator)) {
            classPath = classPath + File.separator;
        }
        String path = file.getAbsolutePath();
        if (StrUtil.isEmpty(packageName)) {
            path = StrUtil.removePrefix(path, classPath);
        }
        String filePathWithDot = path.replace(File.separator, ".");
        int subIndex = -1;
        subIndex = filePathWithDot.indexOf(packageName);
        if (subIndex != -1) {
            int endIndex = filePathWithDot.lastIndexOf(".class");
            String className = filePathWithDot.substring(subIndex, endIndex);
            ClassUtil.fillClass(className, packageName, classes, classFilter);
        }
    }

    private static void processJarFile(File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        try {
            for (JarEntry entry : Collections.list(new JarFile(file).entries())) {
                if (!ClassUtil.isClass(entry.getName())) continue;
                String className = entry.getName().replace("/", ".").replace(".class", "");
                ClassUtil.fillClass(className, packageName, classes, classFilter);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    private static void fillClass(String className, String packageName, Set<Class<?>> classes, ClassFilter classFilter) {
        if (className.startsWith(packageName)) {
            try {
                Class<?> clazz = Class.forName(className, false, ClassUtil.getClassLoader());
                if (classFilter == null || classFilter.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    private static boolean isClassFile(File file) {
        return ClassUtil.isClass(file.getName());
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(".class");
    }

    private static boolean isJarFile(File file) {
        return file.getName().endsWith(".jar");
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

