/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.IoUtil;
import com.xiaoleilu.hutool.SecureUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.HttpException;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest
extends HttpBase<HttpRequest> {
    protected Method method = Method.GET;
    private String url = "";
    private int timeout = -1;
    protected Map<String, Object> form;
    private HttpConnection httpConnection;

    public HttpRequest(String url) {
        this.url = url;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public HttpRequest form(String name, Object value) {
        if (this.form == null) {
            this.form = new HashMap<String, Object>();
            this.body = null;
        }
        this.form.put(name, Conver.toStr(value, null));
        return this;
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        for (Map.Entry<String, Object> entry : formMap.entrySet()) {
            this.form(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public HttpRequest body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return this;
    }

    public HttpRequest body(byte[] content, String contentType) {
        this.contentType(contentType);
        return this.body(StrUtil.str(content, this.charset));
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public HttpResponse execute() {
        if (Method.GET.equals((Object)this.method)) {
            this.url = StrUtil.isNotBlank(this.body) ? HttpUtil.urlWithForm(this.url, this.body) : HttpUtil.urlWithForm(this.url, this.form);
        }
        this.httpConnection = HttpConnection.create(this.url, this.method).setConnectionAndReadTimeout(this.timeout).header(Header.CHAESET, this.charset, true).header(this.headers);
        try {
            if (Method.POST.equals((Object)this.method)) {
                this.send();
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
        HttpResponse httpResponse = HttpResponse.readResponse(this.httpConnection);
        if (!httpResponse.isKeepAlive()) {
            this.httpConnection.disconnect();
            this.httpConnection = null;
        }
        return httpResponse;
    }

    public HttpRequest basicAuth(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = SecureUtil.base64(data, this.charset);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    private void send() throws IOException {
        OutputStream out = this.httpConnection.getOutputStream();
        if (null != out) {
            if (StrUtil.isNotBlank(this.body)) {
                IoUtil.write(out, this.charset, true, this.body);
            } else {
                IoUtil.write(out, this.charset, true, HttpUtil.toParams(this.form));
            }
        }
    }
}

