/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.Func;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.URLUtil;
import com.xiaoleilu.hutool.Validator;
import com.xiaoleilu.hutool.exceptions.HttpException;
import com.xiaoleilu.hutool.http.CookiePool;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import com.xiaoleilu.hutool.http.ssl.DefaultTrustManager;
import com.xiaoleilu.hutool.http.ssl.TrustAnyHostnameVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;

public class HttpConnection {
    private static final Logger log = Log.get();
    private URL url;
    private Method method;
    private HttpURLConnection conn;

    public static HttpConnection create(String urlStr, Method method) {
        return new HttpConnection(urlStr, method);
    }

    public HttpConnection(String urlStr, Method method) {
        if (StrUtil.isBlank(urlStr)) {
            throw new HttpException("Url is blank !");
        }
        if (!Validator.isUrl(urlStr)) {
            throw new HttpException("{} is not a url !", urlStr);
        }
        this.url = URLUtil.url(urlStr);
        this.method = Func.isNull((Object)method) ? Method.GET : method;
        try {
            this.conn = HttpUtil.isHttps(urlStr) ? this.openHttps() : this.openHttp();
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), e);
        }
        this.initConn();
    }

    public HttpConnection initConn() {
        try {
            this.conn.setRequestMethod(this.method.toString());
        }
        catch (ProtocolException e) {
            throw new HttpException(e.getMessage(), e);
        }
        if (this.method.equals((Object)Method.POST)) {
            this.conn.setDoOutput(true);
            this.conn.setUseCaches(false);
        }
        this.conn.setDoInput(true);
        this.header(Header.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8", true);
        this.header(Header.CONTENT_TYPE, "application/x-www-form-urlencoded", true);
        this.header(Header.USER_AGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:36.0) Gecko/20100101 Firefox/36.0 Hutool", true);
        this.setCookie(CookiePool.get(this.url.getHost()));
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public HttpURLConnection getHttpURLConnection() {
        return this.conn;
    }

    public HttpConnection header(String header, String value, boolean isOverride) {
        if (null != this.conn) {
            if (isOverride) {
                this.conn.setRequestProperty(header, value);
            } else {
                this.conn.addRequestProperty(header, value);
            }
        }
        return this;
    }

    public HttpConnection header(Header header, String value, boolean isOverride) {
        return this.header(header.toString(), value, isOverride);
    }

    public HttpConnection header(Map<String, List<String>> headers) {
        if (CollectionUtil.isNotEmpty(headers)) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    this.header(name, StrUtil.nullToEmpty(value), false);
                }
            }
        }
        return this;
    }

    public String header(String name) {
        return this.conn.getHeaderField(name);
    }

    public String header(Header name) {
        return this.header(name.toString());
    }

    public Map<String, List<String>> headers() {
        return this.conn.getHeaderFields();
    }

    public HttpConnection setConnectTimeout(int timeout) {
        if (timeout > 0 && null != this.conn) {
            this.conn.setConnectTimeout(timeout);
        }
        return this;
    }

    public HttpConnection setReadTimeout(int timeout) {
        if (timeout > 0 && null != this.conn) {
            this.conn.setReadTimeout(timeout);
        }
        return this;
    }

    public HttpConnection setConnectionAndReadTimeout(int timeout) {
        this.setConnectTimeout(timeout);
        this.setReadTimeout(timeout);
        return this;
    }

    public HttpConnection setCookie(String cookie) {
        if (cookie != null) {
            this.header(Header.COOKIE, cookie, true);
        }
        return this;
    }

    public HttpConnection setChunkedStreamingMode(int blockSize) {
        this.conn.setChunkedStreamingMode(blockSize);
        return this;
    }

    public HttpConnection connect() throws IOException {
        if (null != this.conn) {
            this.conn.connect();
        }
        return this;
    }

    public HttpConnection disconnect() {
        if (null != this.conn) {
            this.conn.disconnect();
        }
        return this;
    }

    public InputStream getInputStream() throws IOException {
        String setCookie = this.header(Header.SET_COOKIE);
        if (!StrUtil.isBlank(setCookie)) {
            log.debug("Set cookie: [{}]", (Object)setCookie);
            CookiePool.put(this.url.getHost(), setCookie);
        }
        if (null != this.conn) {
            return this.conn.getInputStream();
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (null != this.conn) {
            return this.conn.getOutputStream();
        }
        return null;
    }

    public int responseCode() throws IOException {
        if (null != this.conn) {
            return this.conn.getResponseCode();
        }
        return 0;
    }

    public String charset() {
        return HttpUtil.getCharset(this.conn);
    }

    private HttpURLConnection openHttp() throws IOException {
        return (HttpURLConnection)this.url.openConnection();
    }

    private HttpsURLConnection openHttps() throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.url.openConnection();
        httpsURLConnection.setHostnameVerifier(new TrustAnyHostnameVerifier());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        httpsURLConnection.setSSLSocketFactory(sslContext.getSocketFactory());
        return httpsURLConnection;
    }
}

