/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.SqlRunner;
import com.xiaoleilu.hutool.db.handler.SingleEntityHandler;
import java.sql.SQLException;

public class DaoTemplate {
    protected SqlRunner runner;
    protected String tableName;
    protected String primaryKeyField = "id";

    public DaoTemplate(String tableName) {
        this.tableName = tableName;
    }

    public DaoTemplate(String tableName, String primaryKeyField) {
        this.tableName = tableName;
        this.primaryKeyField = primaryKeyField;
    }

    public DaoTemplate(String tableName, String primaryKeyField, SqlRunner runner) {
        this.tableName = tableName;
        this.primaryKeyField = primaryKeyField;
        this.runner = runner;
    }

    public Long add(Entity entity) throws SQLException {
        return this.runner.insert(entity);
    }

    public <T> int del(T pk) throws SQLException {
        if (pk == null) {
            return 0;
        }
        return this.runner.del(Entity.create(this.tableName).set(this.primaryKeyField, pk));
    }

    public int update(Entity entity) throws SQLException {
        Object pk = entity.get(this.primaryKeyField);
        if (null == pk) {
            throw new SQLException(StrUtil.format("Please determine `{}` for update", this.primaryKeyField));
        }
        Entity where = Entity.create(this.tableName).set(this.primaryKeyField, pk);
        Entity record = (Entity)entity.clone();
        record.remove(this.primaryKeyField);
        return this.runner.update(record, where);
    }

    public int addOrUpdate(Entity entity) throws SQLException {
        if (entity.get(this.primaryKeyField) == null) {
            entity.set(this.primaryKeyField, this.add(entity));
            return 1;
        }
        return this.update(entity);
    }

    public <T> Entity get(T pk) throws SQLException {
        return this.runner.find(null, Entity.create(this.tableName).set(this.primaryKeyField, pk), new SingleEntityHandler());
    }
}

