/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.ClassUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.util.HashMap;
import java.util.Map;

public final class Singleton {
    private static Map<Class<?>, Object> pool = new HashMap();

    private Singleton() {
    }

    public static synchronized <T> T get(Class<?> clazz) {
        Object obj = pool.get(clazz);
        if (null == obj) {
            obj = ClassUtil.newInstance(clazz);
            pool.put(clazz, obj);
        }
        return (T)obj;
    }

    public static <T> T get(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
        return Singleton.get(clazz);
    }

    public static synchronized void remove(Class<?> clazz) {
        pool.remove(clazz);
    }

    public static synchronized void destroy() {
        pool.clear();
    }
}

