/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;

public class InjectUtil {
    private InjectUtil() {
    }

    public static void injectFromRequest(Object model, ServletRequest request, boolean isWithModelName) {
        InjectUtil.injectFromRequest(model, model.getClass().getSimpleName(), request, isWithModelName);
    }

    public static void injectFromRequest(Object model, String modelName, ServletRequest request, boolean isWithModelName) {
        Method[] methods;
        for (Method method : methods = model.getClass().getMethods()) {
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || (types = method.getParameterTypes()).length != 1) continue;
            String fieldName = StrUtil.getGeneralField(methodName);
            String paramName = isWithModelName ? modelName + "." + fieldName : fieldName;
            String value = request.getParameter(paramName);
            if (StrUtil.isEmpty(value)) continue;
            try {
                method.invoke(model, Conver.parse(types[0], value));
            }
            catch (Exception e) {
                throw new UtilException(StrUtil.format("Inject [{}] error!", paramName), e);
            }
        }
    }

    public static void injectFromMap(Object model, Map<?, ?> map) {
        Method[] methods;
        for (Method method : methods = model.getClass().getMethods()) {
            String fieldName;
            Object value;
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || (types = method.getParameterTypes()).length != 1 || (value = map.get(fieldName = StrUtil.getGeneralField(methodName))) == null) continue;
            try {
                method.invoke(model, Conver.parse(types[0], value));
            }
            catch (Exception e) {
                throw new UtilException(StrUtil.format("Inject [{}] error!", fieldName), e);
            }
        }
    }

    public static Map<String, Object> toMap(Object model, boolean isOnlyBasicType) {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method method : methods = model.getClass().getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get")) continue;
            String fieldName = StrUtil.getGeneralField(methodName);
            Object value = null;
            try {
                value = method.invoke(model, new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(StrUtil.format("Inject map [{}] error!", fieldName), e);
            }
            if (value == null || !(value instanceof String) && !value.getClass().isPrimitive() && isOnlyBasicType) continue;
            map.put(fieldName, value);
        }
        return map;
    }
}

