/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.RandomUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.NotInitedException;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static boolean isInited;

    public static synchronized void init(String templateDir, String charset) {
        Velocity.init((Properties)VelocityUtil._newInitedProp(templateDir, charset));
        Velocity.setProperty((String)"file.resource.loader.cache", (Object)true);
        isInited = true;
    }

    public static VelocityEngine newEngine(String templateDir, String charset) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("file.resource.loader.cache", (Object)true);
        ve.init(VelocityUtil._newInitedProp(templateDir, charset));
        return ve;
    }

    public static String getContent(String templateDir, String templateFileName, VelocityContext context, String charset) {
        VelocityEngine ve = VelocityUtil.newEngine(templateDir, charset);
        return VelocityUtil.getContent(ve, templateFileName, context);
    }

    public static String getContent(VelocityEngine ve, String templateFileName, VelocityContext context) {
        StringWriter writer = new StringWriter();
        VelocityUtil.toWriter(ve, templateFileName, context, writer);
        return writer.toString();
    }

    public static String getContent(String templateFileName, VelocityContext context) {
        StringWriter writer = new StringWriter();
        VelocityUtil.toWriter(templateFileName, context, writer);
        return writer.toString();
    }

    public static void toFile(VelocityEngine ve, String templateFileName, VelocityContext context, String destPath) {
        VelocityUtil.toFile(ve.getTemplate(templateFileName), context, destPath);
    }

    public static void toFile(String templateFileName, VelocityContext context, String destPath) {
        VelocityUtil.assertInit();
        VelocityUtil.toFile(Velocity.getTemplate((String)templateFileName), context, destPath);
    }

    public static void toFile(Template template, VelocityContext context, String destPath) {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(destPath, Velocity.getProperty((String)"output.encoding").toString(), false);
            template.merge((Context)context, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new UtilException(StrUtil.format("Write Velocity content to [{}] error!", destPath), e);
            }
            catch (Throwable throwable) {
                FileUtil.close(writer);
                throw throwable;
            }
        }
        FileUtil.close(writer);
    }

    public static void toWriter(VelocityEngine ve, String templateFileName, VelocityContext context, Writer writer) {
        Template template = ve.getTemplate(templateFileName);
        template.merge((Context)context, writer);
    }

    public static void toWriter(String templateFileName, VelocityContext context, Writer writer) {
        VelocityUtil.assertInit();
        Template template = Velocity.getTemplate((String)templateFileName);
        template.merge((Context)context, writer);
    }

    public static String merge(String templateContent, VelocityContext context) {
        StringWriter writer = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)writer, (String)RandomUtil.randomUUID(), (String)templateContent);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return writer.toString();
    }

    public static void toWriter(String templateFileName, HttpServletRequest request, HttpServletResponse response) {
        VelocityContext context = VelocityUtil.parseRequest(request);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            VelocityUtil.toWriter(templateFileName, context, writer);
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Write Velocity content template by [{}] to response error!", templateFileName), e);
        }
        finally {
            FileUtil.close(writer);
        }
    }

    public static VelocityContext parseRequest(HttpServletRequest request) {
        VelocityContext context = new VelocityContext();
        Enumeration attrs = request.getAttributeNames();
        String attrName = null;
        while (attrs.hasMoreElements()) {
            attrName = (String)attrs.nextElement();
            context.put(attrName, request.getAttribute(attrName));
        }
        return context;
    }

    private static Properties _newInitedProp(String templateDir, String charset) {
        Properties properties = new Properties();
        properties.setProperty("file.resource.loader.path", templateDir);
        properties.setProperty("ISO-8859-1", charset);
        properties.setProperty("input.encoding", charset);
        properties.setProperty("output.encoding", charset);
        return properties;
    }

    private static void assertInit() {
        if (!isInited) {
            throw new NotInitedException("Please use VelocityUtil.init() method to init Velocity default engine!");
        }
    }
}

