/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.URLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;

public final class Props
extends Properties {
    private static final long serialVersionUID = 1935981579709590740L;
    private static Logger log = Log.get();
    private URL propertiesFileUrl;

    public Props(String pathBaseClassLoader) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = URLUtil.getURL(pathBaseClassLoader)) == null) {
            throw new RuntimeException(StrUtil.format("Can not find properties file: [{}]", pathBaseClassLoader));
        }
        this.load(url);
    }

    public Props(File propertiesFile) {
        if (propertiesFile == null) {
            throw new RuntimeException("Null properties file!");
        }
        URL url = URLUtil.getURL(propertiesFile);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", propertiesFile.getAbsolutePath()));
        }
        this.load(url);
    }

    public Props(String path, Class<?> clazz) {
        URL url = URLUtil.getURL(path, clazz);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", path));
        }
        this.load(url);
    }

    public Props(URL propertiesUrl) {
        this.load(propertiesUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL propertiesFileUrl) {
        if (propertiesFileUrl == null) {
            throw new RuntimeException("Null properties file url define!");
        }
        log.debug("Load properties [{}]", (Object)propertiesFileUrl.getPath());
        InputStream in = null;
        try {
            in = propertiesFileUrl.openStream();
            super.load(in);
        }
        catch (IOException e) {
            log.error("Load properties error!", (Throwable)e);
        }
        finally {
            FileUtil.close(in);
        }
        this.propertiesFileUrl = propertiesFileUrl;
    }

    public void reload() {
        this.load(this.propertiesFileUrl);
    }

    public String getStr(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    public String getStr(String key) {
        return super.getProperty(key);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return Conver.toInt(this.getStr(key), defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Boolean getBool(String key, Boolean defaultValue) {
        return Conver.toBool(this.getStr(key), defaultValue);
    }

    public Boolean getBool(String key) {
        return this.getBool(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        return Conver.toLong(this.getStr(key), defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(key, null);
    }

    public Character getChar(String key, String defaultValue) {
        String value = this.getStr(key, defaultValue);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Conver.toDouble(this.getStr(key), defaultValue);
    }

    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, null);
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) {
        try {
            FileUtil.touch(absolutePath);
            super.store(FileUtil.getOutputStream(absolutePath), null);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Log.error(log, e, "Store properties to [{}] error!", absolutePath);
        }
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path, clazz));
    }
}

