/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class RandomUtil {
    private static Random random = new Random();
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static int randomInt(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomInt(int limit) {
        return random.nextInt(limit);
    }

    public static <T> T randomEle(List<T> list) {
        return RandomUtil.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        return list.get(RandomUtil.randomInt(limit));
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (--count > 0) {
            result.add(RandomUtil.randomEle(list, limit));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtil.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        StringBuffer sb = new StringBuffer();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }
}

