/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.CharsetUtil;
import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;

public class IoUtil {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static int copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, writer, 1024);
    }

    public static int copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        int readSize;
        char[] buffer = new char[bufferSize];
        int count = 0;
        while ((readSize = reader.read(buffer, 0, bufferSize)) >= 0) {
            writer.write(buffer, 0, readSize);
            count += readSize;
        }
        writer.flush();
        return count;
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        return IoUtil.copy(in, out, 1024);
    }

    public static int copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        int n = -1;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
            count += n;
        }
        out.flush();
        return count;
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        return inChannel.transferTo(0L, inChannel.size(), outChannel);
    }

    public static BufferedReader getReader(InputStream in, String charset) throws IOException {
        InputStreamReader reader = null;
        reader = StrUtil.isBlank(charset) ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static String getString(InputStream in, String charset) throws IOException {
        long len = in.available();
        if (len >= Integer.MAX_VALUE) {
            throw new IOException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        in.read(bytes);
        return new String(bytes, charset);
    }

    public static <T extends Collection<String>> T getLines(InputStream in, String charset, T collection) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        String line = null;
        while ((line = reader.readLine()) != null) {
            collection.add((String)line);
        }
        return collection;
    }

    public static String getString(FileChannel fileChannel, String charset) throws IOException {
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        return CharsetUtil.str(buffer, charset);
    }

    public static ByteArrayInputStream toStream(String content, String charset) {
        if (content == null) {
            return null;
        }
        byte[] data = null;
        try {
            data = StrUtil.isBlank(charset) ? content.getBytes() : content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Invalid charset [{}] !", charset), e);
        }
        return new ByteArrayInputStream(data);
    }

    public static void write(OutputStream out, String charset, boolean isCloseOut, Object ... contents) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Conver.toStr(content, ""));
            }
        }
        catch (Exception e) {
            throw new IOException("Write content to OutputStream error!", e);
        }
        finally {
            if (isCloseOut) {
                FileUtil.close(osw);
            }
        }
    }

    public static void echo(Object content, Object ... param) {
        if (content == null) {
            System.out.println(content);
        }
        System.out.println(StrUtil.format(content.toString(), param));
    }
}

