/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bloomFilter;

import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.Hashs;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;

public class BloomFilter2 {
    private BitSet bitSet;
    private int bitSetSize;
    private int addedElements;
    private int hashFunctionNumber;

    public BloomFilter2(int c, int n, int k) {
        this.hashFunctionNumber = k;
        this.bitSetSize = (int)Math.ceil(c * k);
        this.addedElements = n;
        this.bitSet = new BitSet(this.bitSetSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path, String charset) throws IOException {
        BufferedReader reader = FileUtil.getReader(path, charset);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.put(line);
            }
        }
        finally {
            FileUtil.close(reader);
        }
    }

    public void put(String str) {
        int[] positions = BloomFilter2.createHashes(str, this.hashFunctionNumber);
        for (int i = 0; i < positions.length; ++i) {
            int position = Math.abs(positions[i] % this.bitSetSize);
            this.bitSet.set(position, true);
        }
    }

    public boolean contains(String str) {
        int[] positions;
        for (int i : positions = BloomFilter2.createHashes(str, this.hashFunctionNumber)) {
            int position = Math.abs(i % this.bitSetSize);
            if (this.bitSet.get(position)) continue;
            return false;
        }
        return true;
    }

    public double getFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.hashFunctionNumber) * (double)this.addedElements / (double)this.bitSetSize), this.hashFunctionNumber);
    }

    public static int[] createHashes(String str, int hashNumber) {
        int[] result = new int[hashNumber];
        for (int i = 0; i < hashNumber; ++i) {
            result[i] = BloomFilter2.hash(str, i);
        }
        return result;
    }

    public static int hash(String str, int k) {
        switch (k) {
            case 0: {
                return Hashs.RSHash(str);
            }
            case 1: {
                return Hashs.JSHash(str);
            }
            case 2: {
                return Hashs.ELFHash(str);
            }
            case 3: {
                return Hashs.BKDRHash(str);
            }
            case 4: {
                return Hashs.APHash(str);
            }
            case 5: {
                return Hashs.DJBHash(str);
            }
            case 6: {
                return Hashs.SDBMHash(str);
            }
            case 7: {
                return Hashs.PJWHash(str);
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        BloomFilter2 bloomfilter = new BloomFilter2(30000000, 10000000, 8);
        System.out.println("Bloom Filter Initialize ... ");
        bloomfilter.init("data/base.txt", "utf8");
        System.out.println("Bloom Filter Ready");
        System.out.println("False Positive Probability : " + bloomfilter.getFalsePositiveProbability());
        ArrayList<String> result = new ArrayList<String>();
        long t1 = System.currentTimeMillis();
        BufferedReader reader = new BufferedReader(new FileReader("data/input.txt"));
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            if (!bloomfilter.contains(line)) {
                result.add(line);
            }
            line = reader.readLine();
        }
        reader.close();
        long t2 = System.currentTimeMillis();
        System.out.println("Parse 9900000 items, Time : " + (t2 - t1) + "ms , find " + result.size() + " new items.");
        System.out.println("Average : " + 9900000L / ((t2 - t1) / 1000L) + " items/second");
    }
}

