/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecureUtil {
    public static final String MD2 = "MD2";
    public static final String MD4 = "MD4";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String HMAC_SHA1 = "HmacSHA1";
    public static final String RIPEMD128 = "RIPEMD128";
    public static final String RIPEMD160 = "RIPEMD160";
    private static char[] base64EncodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static String encrypt(String source, String algorithmName, String charset) {
        return SecureUtil.encrypt(StrUtil.encode(source, charset), algorithmName);
    }

    public static String encrypt(byte[] bytes, String algorithmName) {
        return Conver.toHex(SecureUtil.encryptWithoutHex(bytes, algorithmName));
    }

    public static byte[] encryptWithoutHex(byte[] bytes, String algorithmName) {
        MessageDigest md = null;
        try {
            if (StrUtil.isBlank(algorithmName)) {
                algorithmName = MD5;
            }
            md = MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(StrUtil.format("No such algorithm name for: {}", algorithmName));
        }
        return md.digest(bytes);
    }

    public static String sha1(String source, String charset) {
        return SecureUtil.encrypt(source, SHA1, charset);
    }

    public static byte[] mac(String algorithm, byte[] data, byte[] key) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1);
            mac.init(new SecretKeySpec(key, HMAC_SHA1));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(e, "No such algorithm: {}", algorithm);
        }
        catch (InvalidKeyException e) {
            throw new UtilException(e, "Invalid key: {}", new Object[]{key});
        }
        return mac == null ? null : mac.doFinal(data);
    }

    public static byte[] sha1(byte[] data, byte[] key) {
        return SecureUtil.mac(HMAC_SHA1, data, key);
    }

    public static String sha1(String data, String key, String charset) {
        Charset charsetObj = Charset.forName(charset);
        byte[] bytes = SecureUtil.mac(HMAC_SHA1, data.getBytes(charsetObj), key.getBytes(charsetObj));
        return SecureUtil.base64(bytes);
    }

    public static String initMacKey(String algorithm) throws Exception {
        return SecureUtil.base64(KeyGenerator.getInstance(algorithm).generateKey().getEncoded());
    }

    public static String md5(String source, String charset) {
        return SecureUtil.encrypt(source, MD5, charset);
    }

    public static String base64(String source, String charset) {
        return SecureUtil.base64(StrUtil.encode(source, charset));
    }

    public static String base64(byte[] bytes) {
        char c3;
        int b3;
        char c2;
        int b2;
        char c1;
        int b1;
        StringBuilder sb = new StringBuilder();
        int len = bytes.length;
        int len3 = len / 3;
        for (int i = 0; i < len3; ++i) {
            b1 = bytes[i * 3] >> 2 & 0x3F;
            c1 = base64EncodeTable[b1];
            sb.append(c1);
            b2 = (bytes[i * 3] << 4 & 0x3F) + (bytes[i * 3 + 1] >> 4) & 0x3F;
            c2 = base64EncodeTable[b2];
            sb.append(c2);
            b3 = (bytes[i * 3 + 1] << 2 & 0x3C) + (bytes[i * 3 + 2] >> 6) & 0x3F;
            c3 = base64EncodeTable[b3];
            sb.append(c3);
            int b4 = bytes[i * 3 + 2] & 0x3F;
            char c4 = base64EncodeTable[b4];
            sb.append(c4);
        }
        int less = len % 3;
        if (less == 1) {
            b1 = bytes[len3 * 3] >> 2 & 0x3F;
            c1 = base64EncodeTable[b1];
            sb.append(c1);
            b2 = bytes[len3 * 3] << 4 & 0x30 & 0x3F;
            c2 = base64EncodeTable[b2];
            sb.append(c2);
            sb.append("==");
        } else if (less == 2) {
            b1 = bytes[len3 * 3] >> 2 & 0x3F;
            c1 = base64EncodeTable[b1];
            sb.append(c1);
            b2 = (bytes[len3 * 3] << 4 & 0x30) + (bytes[len3 * 3 + 1] >> 4) & 0x3F;
            c2 = base64EncodeTable[b2];
            sb.append(c2);
            b3 = bytes[len3 * 3 + 1] << 2 & 0x3C & 0x3F;
            c3 = base64EncodeTable[b3];
            sb.append(c3);
            sb.append("=");
        }
        return sb.toString();
    }

    public static String decodeBase64(String source, String charset) {
        return SecureUtil.decodeBase64(StrUtil.encode(source, charset));
    }

    public static String decodeBase64(byte[] bytes) {
        int index;
        int len = bytes.length;
        int len4 = len / 4;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (i = 0; i < len4 - 1; ++i) {
            byte b1 = (byte)((SecureUtil.char2Index((char)bytes[i * 4]) << 2) + (SecureUtil.char2Index((char)bytes[i * 4 + 1]) >> 4));
            sb.append((char)b1);
            byte b2 = (byte)((SecureUtil.char2Index((char)bytes[i * 4 + 1]) << 4) + (SecureUtil.char2Index((char)bytes[i * 4 + 2]) >> 2));
            sb.append((char)b2);
            byte b3 = (byte)((SecureUtil.char2Index((char)bytes[i * 4 + 2]) << 6) + SecureUtil.char2Index((char)bytes[i * 4 + 3]));
            sb.append((char)b3);
        }
        for (int j = 0; j < 3 && (char)bytes[(index = i * 4 + j) + 1] != '='; ++j) {
            byte b;
            if (j == 0) {
                b = (byte)((SecureUtil.char2Index((char)bytes[index]) << 2) + (SecureUtil.char2Index((char)bytes[index + 1]) >> 4));
                sb.append((char)b);
                continue;
            }
            if (j == 1) {
                b = (byte)((SecureUtil.char2Index((char)bytes[index]) << 4) + (SecureUtil.char2Index((char)bytes[index + 1]) >> 2));
                sb.append((char)b);
                continue;
            }
            if (j != 2) continue;
            b = (byte)((SecureUtil.char2Index((char)bytes[index]) << 6) + SecureUtil.char2Index((char)bytes[index + 1]));
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static int char2Index(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65;
        }
        if (ch >= 'a' && ch <= 'z') {
            return 26 + ch - 97;
        }
        if (ch >= '0' && ch <= '9') {
            return 52 + ch - 48;
        }
        if (ch == '+') {
            return 62;
        }
        if (ch == '/') {
            return 63;
        }
        return 0;
    }
}

