/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bloomFilter;

import com.xiaoleilu.hutool.bloomFilter.filter.DefaultFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.ELFFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.Filter;
import com.xiaoleilu.hutool.bloomFilter.filter.JSFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.PJWFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.SDBMFilter;

public class BloomFilter {
    private Filter[] filters;

    public BloomFilter(int m) {
        float mNum = m / 5;
        long size = (long)(1.0f * mNum * 1024.0f * 1024.0f * 8.0f);
        this.filters = new Filter[]{new DefaultFilter(size), new ELFFilter(size), new JSFilter(size), new PJWFilter(size), new SDBMFilter(size)};
    }

    public BloomFilter(int m, Filter ... filters) {
        this.filters = filters;
    }

    public void add(String str) {
        for (Filter filter : this.filters) {
            filter.add(str);
        }
    }

    public boolean contains(String str) {
        for (Filter filter : this.filters) {
            if (filter.contains(str)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAndAdd(String str) {
        boolean flag = true;
        for (Filter filter : this.filters) {
            flag &= filter.containsAndAdd(str);
        }
        return flag;
    }
}

