/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReUtil {
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final Pattern NUMBER = Pattern.compile("\\d+", 32);
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)", 32);
    public static final Pattern IPV4 = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", 32);
    public static final Set<Character> RE_KEYS = CollectionUtil.newHashSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    private ReUtil() {
    }

    public static String get(String regex, String content, int groupIndex) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, String content, int groupIndex) {
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String extractMulti(Pattern pattern, String content, String template) {
        HashSet<String> varNums = ReUtil.findAll(GROUP_VAR, template, 1, new HashSet());
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(Pattern pattern, String[] contents, String template) {
        HashSet<String> varNums = ReUtil.findAll(GROUP_VAR, template, 1, new HashSet());
        String content = contents[0];
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contents[0] = StrUtil.sub(content, matcher.end(), content.length());
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, String content, String template) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(String regex, String[] contents, String template) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.extractMultiAndDelPre(pattern, contents, template);
    }

    public static String delFirst(String regex, String content) {
        return content.replaceFirst(regex, "");
    }

    public static String delPre(String regex, String content) {
        Matcher matcher = Pattern.compile(regex, 32).matcher(content);
        if (matcher.find()) {
            return StrUtil.sub(content, matcher.end(), content.length());
        }
        return content;
    }

    public static <T extends Collection<String>> T findAll(String regex, String content, int group, T collection) {
        Pattern pattern = Pattern.compile(regex, 32);
        return ReUtil.findAll(pattern, content, group, collection);
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, String content, int group, T collection) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static Integer getFirstNumber(String StringWithNumber) {
        return Conver.toInt(ReUtil.get(NUMBER, StringWithNumber, 0), null);
    }

    public static boolean isIpv4(String ip) {
        if (StrUtil.isBlank(ip)) {
            return false;
        }
        return IPV4.matcher(ip).matches();
    }

    public static boolean isMatch(String regex, String content) {
        if (content == null) {
            return false;
        }
        if (StrUtil.isEmpty(regex)) {
            return true;
        }
        return Pattern.matches(regex, content);
    }

    public static String replaceAll(String content, String regex, String replacementTemplate) {
        if (StrUtil.isEmpty(content)) {
            return content;
        }
        Matcher matcher = Pattern.compile(regex, 32).matcher(content);
        matcher.reset();
        boolean result = matcher.find();
        if (result) {
            Set varNums = ReUtil.findAll(GROUP_VAR, replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, ReUtil.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    public static String escape(String content) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

