/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.SqlExecutor;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.handler.NumberHandler;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

public class SqlConnRunner
extends SqlExecutor {
    private Dialect dialect;

    public SqlConnRunner(Dialect dialect) {
        Log.info("Use Dialect: [{}].", dialect.getClass().getSimpleName());
        this.dialect = dialect;
    }

    public SqlConnRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    public Long insert(Connection conn, Entity record) throws SQLException {
        Long l;
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            l = DbUtil.getGeneratedKey(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return l;
    }

    public int del(Connection conn, Entity where) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, where);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, where);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T find(Connection conn, Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        T t;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.dialect.psForFind(conn, fields, where);
            rs = ps.executeQuery();
            t = rsh.handle(rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, ps);
                throw throwable;
            }
        }
        DbUtil.close(rs, ps);
        return t;
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        T t;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.dialect.psForPage(conn, fields, where, page, numPerPage);
            rs = ps.executeQuery();
            t = rsh.handle(rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, ps);
                throw throwable;
            }
        }
        DbUtil.close(rs, ps);
        return t;
    }

    public int count(Connection conn, Entity where) throws SQLException {
        int n;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.dialect.psForCount(conn, where);
            rs = ps.executeQuery();
            n = new NumberHandler().handle(rs).intValue();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, ps);
                throw throwable;
            }
        }
        DbUtil.close(rs, ps);
        return n;
    }
}

