/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bloomFilter.filter;

import com.xiaoleilu.hutool.bloomFilter.bitMap.BitMap;
import com.xiaoleilu.hutool.bloomFilter.bitMap.IntMap;
import com.xiaoleilu.hutool.bloomFilter.bitMap.LongMap;
import com.xiaoleilu.hutool.bloomFilter.filter.Filter;

public abstract class AbstractFilter
implements Filter {
    private BitMap bm = null;
    protected long size = 0L;

    public AbstractFilter(long maxValue, int machineNum) {
        this.size = maxValue;
        switch (machineNum) {
            case 32: {
                this.bm = new IntMap((int)(this.size / (long)machineNum));
                break;
            }
            case 64: {
                this.bm = new LongMap((int)(this.size / (long)machineNum));
                break;
            }
            default: {
                throw new RuntimeException("Error Machine number!");
            }
        }
    }

    public AbstractFilter(long maxValue) {
        this(maxValue, 32);
    }

    @Override
    public boolean contains(String str) {
        return this.bm.contains(this.hash(str));
    }

    @Override
    public void add(String str) {
        this.bm.add(this.hash(str));
    }

    @Override
    public boolean containsAndAdd(String str) {
        long hash = this.hash(str);
        if (this.bm.contains(hash)) {
            return true;
        }
        this.bm.add(hash);
        return false;
    }

    @Override
    public abstract long hash(String var1);
}

