/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SecureUtil {
    public static final String MD2 = "MD2";
    public static final String MD4 = "MD4";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String RIPEMD128 = "RIPEMD128";
    public static final String RIPEMD160 = "RIPEMD160";

    public static String md5(byte[] source) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
        }
        catch (Exception e) {
            throw new UtilException("Get MD5 error!", e);
        }
        return s;
    }

    public static String md5(String source, String charset) {
        if (source == null) {
            return null;
        }
        if (StrUtil.isBlank(charset)) {
            return SecureUtil.md5(source.getBytes());
        }
        try {
            return SecureUtil.md5(source.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException("Unsupported encoding: " + charset, e);
        }
    }

    public static String encrypt(String source, String algorithmName, String charset) {
        byte[] bt = StrUtil.encode(source, charset);
        MessageDigest md = null;
        try {
            if (StrUtil.isBlank(algorithmName)) {
                algorithmName = MD5;
            }
            md = MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(StrUtil.format("No such algorithm name for: {}", algorithmName));
        }
        md.update(bt);
        return Conver.toHex(md.digest());
    }

    public String sha1(String source, String charset) {
        return SecureUtil.encrypt(source, SHA1, charset);
    }
}

