/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AnsiSqlDialect
implements Dialect {
    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO `").append(entity.getTableName()).append("`(");
        StringBuilder placeHolder = new StringBuilder();
        placeHolder.append(") values(");
        ArrayList paramValues = new ArrayList(entity.size());
        for (Map.Entry entry : entity.entrySet()) {
            if (paramValues.size() > 0) {
                sql.append(", ");
                placeHolder.append(", ");
            }
            sql.append("`").append((String)entry.getKey()).append("`");
            placeHolder.append("?");
            paramValues.add(entry.getValue());
        }
        sql.append(placeHolder.toString()).append(")");
        PreparedStatement ps = conn.prepareStatement(sql.toString(), 1);
        DbUtil.fillParams(ps, paramValues.toArray(new Object[paramValues.size()]));
        return ps;
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Entity entity) throws SQLException {
        if (null == entity || entity.isEmpty()) {
            throw new SQLException("No condition define, we can't build delete query for del everything.");
        }
        ArrayList<Object> paramValues = new ArrayList<Object>(entity.size());
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM `").append(entity.getTableName()).append("`").append(DbUtil.buildEqualsWhere(entity, paramValues));
        PreparedStatement ps = conn.prepareStatement(sql.toString());
        DbUtil.fillParams(ps, paramValues.toArray(new Object[paramValues.size()]));
        return ps;
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Entity where) throws SQLException {
        if (null == entity || entity.isEmpty()) {
            throw new SQLException("No condition define, we can't build update query for update everything.");
        }
        ArrayList<Object> paramValues = new ArrayList<Object>(entity.size());
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE `").append(entity.getTableName()).append("` SET ");
        for (Map.Entry entry : entity.entrySet()) {
            if (paramValues.size() > 0) {
                sql.append(", ");
            }
            sql.append("`").append((String)entry.getKey()).append("` = ? ");
            paramValues.add(entry.getValue());
        }
        sql.append(DbUtil.buildEqualsWhere(where, paramValues));
        PreparedStatement ps = conn.prepareStatement(sql.toString());
        DbUtil.fillParams(ps, paramValues.toArray(new Object[paramValues.size()]));
        return ps;
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Collection<String> fields, Entity where) throws SQLException {
        ArrayList<Object> paramValues = new ArrayList<Object>(where.size());
        StringBuilder sql = this.buildSelectQuery(fields, where, paramValues);
        PreparedStatement ps = conn.prepareStatement(sql.toString());
        DbUtil.fillParams(ps, paramValues.toArray(new Object[paramValues.size()]));
        return ps;
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        throw new SQLException("ANSI SQL is not support for page query!");
    }

    @Override
    public PreparedStatement psForCount(Connection conn, Entity where) throws SQLException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("count(1)");
        return this.psForFind(conn, fields, where);
    }

    protected StringBuilder buildSelectQuery(Collection<String> fields, Entity where, List<Object> paramValues) {
        StringBuilder sql = new StringBuilder("SELECT ");
        if (CollectionUtil.isEmpty(fields)) {
            sql.append("*");
        } else {
            sql.append(CollectionUtil.join(fields, ","));
        }
        sql.append(" FROM `").append(where.getTableName()).append("`").append(DbUtil.buildEqualsWhere(where, paramValues));
        return sql;
    }
}

