/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.CollectionUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class StrUtil {
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CRLF = "\r\n";
    public static final String NEWLINE = "\n";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return false == StrUtil.isBlank(str);
    }

    public static boolean hasBlank(String ... strs) {
        for (String str : strs) {
            if (!StrUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return false == StrUtil.isEmpty(str);
    }

    public static boolean hasEmpty(String ... strs) {
        for (String str : strs) {
            if (!StrUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String trim(String str) {
        return null == str ? null : str.trim();
    }

    public static String getGeneralField(String getOrSetMethodName) {
        if (getOrSetMethodName.startsWith("get") || getOrSetMethodName.startsWith("set")) {
            return StrUtil.cutPreAndLowerFirst(getOrSetMethodName, 3);
        }
        return null;
    }

    public static String genSetter(String fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(String fieldName) {
        return StrUtil.upperFirstAndAddPre(fieldName, "get");
    }

    public static String cutPreAndLowerFirst(String str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return null;
    }

    public static String upperFirstAndAddPre(String str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StrUtil.upperFirst(str);
    }

    public static String upperFirst(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String lowerFirst(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String removePrefix(String str, String prefix) {
        if (str != null && str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        if (str != null && str.toLowerCase().startsWith(prefix.toLowerCase())) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (str != null && str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        if (str != null && str.toLowerCase().endsWith(suffix.toLowerCase())) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String cleanBlank(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s*", EMPTY);
    }

    public static List<String> split(String str, char separator) {
        return StrUtil.split(str, separator, 0);
    }

    public static List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] split(String str, String delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String sub(String string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            fromIndex = len + fromIndex;
            if (toIndex == 0) {
                toIndex = len;
            }
        }
        if (toIndex < 0) {
            toIndex = len + toIndex;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        char[] strArray = string.toCharArray();
        char[] newStrArray = Arrays.copyOfRange(strArray, fromIndex, toIndex);
        return new String(newStrArray);
    }

    public static String subPre(String string, int toIndex) {
        return StrUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(String string, int fromIndex) {
        if (StrUtil.isEmpty(string)) {
            return null;
        }
        return StrUtil.sub(string, fromIndex, string.length());
    }

    public static String repeat(char c, int count) {
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(String str, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StrUtil.isBlank(str) || StrUtil.isBlank(sourceCharset) || StrUtil.isBlank(destCharset)) {
            return str;
        }
        try {
            return new String(str.getBytes(sourceCharset), destCharset);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static boolean equalsNotEmpty(String str1, String str2) {
        if (StrUtil.isEmpty(str1)) {
            return false;
        }
        return str1.equals(str2);
    }

    public static String format(String template, Object ... values) {
        if (CollectionUtil.isEmpty(values) || StrUtil.isBlank(template)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int length = template.length();
        int valueIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (valueIndex >= values.length) {
                sb.append(StrUtil.sub(template, i, length));
                break;
            }
            char currentChar = template.charAt(i);
            if (currentChar == '{') {
                char nextChar;
                if ((nextChar = template.charAt(++i)) == '}') {
                    sb.append(values[valueIndex++]);
                    continue;
                }
                sb.append('{').append(nextChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String format(String template, Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return template;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template.replace("{" + entry.getKey() + "}", entry.getValue().toString());
        }
        return template;
    }

    public static byte[] encode(String str, String charset) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(StrUtil.format("Charset [{}] unsupported!", charset));
        }
    }

    public static String decode(byte[] data, String charset) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(StrUtil.format("Charset [{}] unsupported!", charset));
        }
    }

    public static String str(Object ... objs) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objs) {
            sb.append(obj);
        }
        return sb.toString();
    }
}

