/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.IoUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.ReUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HttpUtil {
    public static final String UNKNOW = "unknown";
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*?)\"");
    private static Map<String, String> cookies = new HashMap<String, String>();

    public static String encode(String content, String charset) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charset), e);
        }
        return encodeContent;
    }

    public static String decode(String content, String charset) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charset), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.indexOf(",") > 0) {
            ip = ip.trim().split(",")[0];
        }
        return ip;
    }

    public static String get(String urlString, String customCharset, boolean isPassCodeError) throws IOException {
        URL url = new URL(urlString);
        String host = url.getHost();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1");
        String cookie = cookies.get(host);
        if (cookie != null) {
            conn.addRequestProperty("Cookie", cookie);
        }
        conn.setRequestMethod("GET");
        conn.setDoInput(true);
        if (conn.getResponseCode() != 200 && !isPassCodeError) {
            throw new IOException("Status code not 200!");
        }
        String setCookie = conn.getHeaderField("Set-Cookie");
        if (!StrUtil.isBlank(setCookie)) {
            Log.debug("Set cookie: [{}]", setCookie);
            cookies.put(host, setCookie);
        }
        String charset = HttpUtil.getCharsetFromConn(conn);
        boolean isGetCharsetFromContent = false;
        if (StrUtil.isBlank(charset)) {
            charset = customCharset;
            isGetCharsetFromContent = true;
        }
        String content = HttpUtil.getString(conn.getInputStream(), charset, isGetCharsetFromContent);
        conn.disconnect();
        return content;
    }

    public static String post(String urlString, Map<String, Object> paramMap, String customCharset, boolean isPassCodeError) throws IOException {
        return HttpUtil.post(urlString, HttpUtil.toParams(paramMap), customCharset, isPassCodeError);
    }

    public static String post(String urlString, String params, String customCharset, boolean isPassCodeError) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        IoUtil.write(conn.getOutputStream(), customCharset, true, params);
        if (conn.getResponseCode() != 200 && !isPassCodeError) {
            throw new IOException("Status code not 200!");
        }
        String charset = HttpUtil.getCharsetFromConn(conn);
        String content = IoUtil.getString(conn.getInputStream(), StrUtil.isBlank(charset) ? customCharset : charset);
        conn.disconnect();
        return content;
    }

    public static String downloadString(String url, String customCharset) throws IOException {
        InputStream inputStream = new URL(url).openStream();
        return IoUtil.getString(inputStream, customCharset);
    }

    public static String toParams(Map<String, Object> paramMap) {
        return CollectionUtil.join(paramMap.entrySet(), "&");
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StrUtil.isBlank(paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > 0) {
            paramsStr = StrUtil.subSuf(paramsStr, pathEndPos + 1);
        }
        paramsStr = HttpUtil.decode(paramsStr, charset);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        for (i = 0; i < paramsStr.length(); ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "");
        }
        return params;
    }

    private static String getCharsetFromConn(HttpURLConnection conn) {
        String charset = conn.getContentEncoding();
        if (charset == null || "".equals(charset.trim())) {
            String contentType = conn.getContentType();
            charset = ReUtil.get("charset=(.*)", contentType, 1);
        }
        return charset;
    }

    private static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || UNKNOW.equalsIgnoreCase(checkString);
    }

    private static String getString(InputStream in, String charset, boolean isGetCharsetFromContent) throws IOException {
        StringBuilder content = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String charsetInContent;
            content.append(line).append('\n');
            if (!isGetCharsetFromContent || StrUtil.isBlank(charsetInContent = ReUtil.get(CHARSET_PATTERN, line, 1))) continue;
            charset = charsetInContent;
            reader = new BufferedReader(new InputStreamReader(in, charset));
            isGetCharsetFromContent = true;
        }
        return content.toString();
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }
}

