/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.Setting;
import it.sauronsoftware.cron4j.Scheduler;
import java.util.Map;
import org.slf4j.Logger;

public class CronUtil {
    private static Logger log = Log.get();
    public static final String CRONTAB_CONFIG_PATH = "config/cron4j.setting";
    private static Scheduler scheduler = new Scheduler();

    public static void schedule(String schedulingPattern, Runnable task) {
        scheduler.schedule(schedulingPattern, task);
    }

    public static void start() {
        Setting crontab = new Setting(CRONTAB_CONFIG_PATH, "utf8", false);
        for (Map.Entry entry : crontab.entrySet()) {
            String jobClass = (String)entry.getKey();
            String pattern = (String)entry.getValue();
            try {
                Class<?> clazz = Class.forName(jobClass);
                Runnable job = (Runnable)clazz.newInstance();
                scheduler.schedule(pattern, job);
                log.info("Schedule [{} {}] added.", (Object)pattern, (Object)jobClass);
            }
            catch (Exception e) {
                Log.error(log, e, "Schedule [%s %s] add error!", pattern, jobClass);
            }
        }
        scheduler.start();
    }

    public static void stop() {
        scheduler.stop();
    }
}

