/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.math.BigDecimal;
import java.util.Set;

public class Conver {
    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        String valueStr = value.toString();
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @SafeVarargs
    public static <T> Integer[] toIntArray(boolean isIgnoreConvertError, T ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        Integer[] ints = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer v = Conver.toInt(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Integer error!", values[i]));
            }
            ints[i] = v;
        }
        return ints;
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        String valueStr = value.toString();
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @SafeVarargs
    public static <T> Long[] toLongArray(boolean isIgnoreConvertError, T ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        Long[] longs = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long v = Conver.toLong(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Long error!", values[i]));
            }
            longs[i] = v;
        }
        return longs;
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        String valueStr = value.toString();
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @SafeVarargs
    public static <T> Double[] toDoubleArray(boolean isIgnoreConvertError, T ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        Double[] doubles = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            Double v = Conver.toDouble(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Double error!", values[i]));
            }
            doubles[i] = v;
        }
        return doubles;
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        String valueStr = value.toString();
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueStr));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @SafeVarargs
    public static <T> Float[] toFloatArray(boolean isIgnoreConvertError, T ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        Float[] floats = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            Float v = Conver.toFloat(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Float error!", values[i]));
            }
            floats[i] = v;
        }
        return floats;
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueStr = value.toString();
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @SafeVarargs
    public static <T> Boolean[] toBooleanArray(boolean isIgnoreConvertError, T ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        Boolean[] bools = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            Boolean v = Conver.toBool(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Boolean error!", values[i]));
            }
            bools[i] = v;
        }
        return bools;
    }

    public static String toSBC(String input) {
        return Conver.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Conver.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }
}

