/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.lang;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassUtil.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        try {
            loader.addJar(jarFile);
        }
        finally {
            IoUtil.close(loader);
        }
        return loader;
    }

    public void addJar(File jarFile) {
        List<File> jars = JarClassLoader.loopJar(jarFile);
        try {
            for (File jar : jars) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    private static List<File> loopJar(File file) {
        return FileUtil.loopFiles(file, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getPath();
                return path != null && path.endsWith(".jar");
            }
        });
    }
}

