/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.json;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.json.JSON;
import com.xiaoleilu.hutool.json.JSONArray;
import com.xiaoleilu.hutool.json.JSONException;
import com.xiaoleilu.hutool.json.JSONGetter;
import com.xiaoleilu.hutool.json.JSONNull;
import com.xiaoleilu.hutool.json.JSONTokener;
import com.xiaoleilu.hutool.json.JSONUtil;
import com.xiaoleilu.hutool.util.BeanUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSONGetter<String>
implements JSON,
Map<String, Object> {
    private final Map<String, Object> rawHashMap = new HashMap<String, Object>();

    public JSONObject() {
    }

    public JSONObject(JSONObject jsonObject, String ... names) {
        for (String name : names) {
            try {
                this.putOnce(name, jsonObject.getObj(name));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this.init(x);
    }

    public JSONObject(Object source) {
        if (null != source) {
            if (source instanceof Map) {
                for (Map.Entry e : ((Map)source).entrySet()) {
                    Object value = e.getValue();
                    if (value == null) continue;
                    this.rawHashMap.put(Convert.toStr(e.getKey()), JSONUtil.wrap(value));
                }
            } else if (source instanceof String) {
                this.init((String)source);
            } else {
                this.populateMap(source);
            }
        }
    }

    public JSONObject(Object object, String[] names) {
        Class<?> c = object.getClass();
        for (String name : names) {
            try {
                this.putOpt(name, c.getField(name).get(object));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public boolean isNull(String key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.put(value);
        }
        return ja;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.mapToBean(this.rawHashMap, clazz, false);
    }

    public <T> T toBean(T bean) {
        return BeanUtil.fillBeanWithMap(this.rawHashMap, bean, false);
    }

    @Override
    public int size() {
        return this.rawHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawHashMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.rawHashMap.get(key);
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object obj = this.rawHashMap.get(key);
        return null == obj ? defaultValue : obj;
    }

    @Override
    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            JSONUtil.testValidity(value);
            this.rawHashMap.put(key, JSONUtil.wrap(value));
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.rawHashMap.containsKey(key)) {
                throw new JSONException(StrUtil.format("Duplicate key \"{}\"", key));
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.rawHashMap.putAll(m);
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            this.put(key, (Object)new JSONArray().put(object).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, (Object)new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            this.put(key, (Object)((JSONArray)object).put(value));
        } else {
            throw new JSONException("JSONObject [" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.put(key, (Object)1);
        } else if (value instanceof BigInteger) {
            this.put(key, (Object)((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.put(key, (Object)((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.put(key, (Object)((Integer)value + 1));
        } else if (value instanceof Long) {
            this.put(key, (Object)((Long)value + 1L));
        } else if (value instanceof Double) {
            this.put(key, (Object)((Double)value + 1.0));
        } else if (value instanceof Float) {
            this.put(key, (Object)Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONUtil.quote(key) + "].");
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.rawHashMap.remove(key);
    }

    @Override
    public void clear() {
        this.rawHashMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawHashMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.rawHashMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rawHashMap.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        try {
            if (!(other instanceof JSONObject)) {
                return false;
            }
            Set<String> set = this.keySet();
            if (!set.equals(((JSONObject)other).keySet())) {
                return false;
            }
            for (String name : set) {
                Object valueThis = this.getObj(name);
                Object valueOther = ((JSONObject)other).getObj(name);
                if (!(valueThis instanceof JSONObject ? !((JSONObject)valueThis).equals(valueOther) : (valueThis instanceof JSONArray ? !((JSONArray)valueThis).equals(valueOther) : !valueThis.equals(valueOther)))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.toJSONString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJSONString(int indentFactor) throws JSONException {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            return this.write(w, indentFactor, 0).toString();
        }
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.size();
            Iterator<String> keys = this.keySet().iterator();
            writer.write(123);
            if (length == 1) {
                String key = keys.next();
                writer.write(JSONUtil.quote(key.toString()));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                JSONUtil.writeValue(writer, this.rawHashMap.get(key), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONUtil.indent(writer, newindent);
                    writer.write(JSONUtil.quote(key.toString()));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    JSONUtil.writeValue(writer, this.rawHashMap.get(key), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONUtil.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private void populateMap(Object bean) {
        Class<?> clazz = bean.getClass();
        boolean includeSuperClass = clazz.getClassLoader() != null;
        Method[] methods = includeSuperClass ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (result == null) continue;
                this.rawHashMap.put(key, JSONUtil.wrap(result));
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    private void init(String source) {
        this.init(new JSONTokener(source));
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }
}

