/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.io.resource;

import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassPathResource {
    private String path;
    private ClassLoader classLoader;
    private Class<?> clazz;
    private URL url;

    public ClassPathResource(String path) {
        this(path, null, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, null, clazz);
    }

    public ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        Assert.notNull(path, "Path must not be null");
        this.path = path;
        this.classLoader = classLoader != null ? classLoader : ClassUtil.getClassLoader();
        this.clazz = clazz;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final URL getUrl() {
        return this.url;
    }

    public InputStream getStream() {
        if (null == this.url) {
            throw new IORuntimeException("Resource [{}] not exist!", this.path);
        }
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
    }
}

