/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds;

import com.xiaoleilu.hutool.db.ds.c3p0.C3p0DSFactory;
import com.xiaoleilu.hutool.db.ds.dbcp.DbcpDSFactory;
import com.xiaoleilu.hutool.db.ds.druid.DruidDSFactory;
import com.xiaoleilu.hutool.db.ds.hikari.HikariDSFactory;
import com.xiaoleilu.hutool.db.ds.pooled.PooledDSFactory;
import com.xiaoleilu.hutool.db.ds.tomcat.TomcatDSFactory;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.setting.Setting;
import javax.sql.DataSource;

public abstract class DSFactory {
    private static final Log log = LogFactory.get();
    protected static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    private String dataSourceName;
    private static DSFactory currentDSFactory;
    private static final Object lock;

    public DSFactory(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public DataSource getDataSource() {
        return this.getDataSource("");
    }

    public abstract DataSource getDataSource(String var1);

    public void close() {
        this.close("");
    }

    public abstract void close(String var1);

    public abstract void destroy();

    protected void checkCPExist(Class<? extends DataSource> dsClass) {
    }

    public static DataSource get() {
        return DSFactory.get(null);
    }

    public static DataSource get(String group) {
        return DSFactory.get(null, group);
    }

    public static DataSource get(Setting dbSetting, String group) {
        return DSFactory.getCurrentDSFactory(dbSetting).getDataSource(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSFactory getCurrentDSFactory(Setting setting) {
        if (null == currentDSFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentDSFactory) {
                    currentDSFactory = DSFactory.detectDSFactory(setting);
                }
            }
        }
        return currentDSFactory;
    }

    public static DSFactory setCurrentDSFactory(DSFactory dsFactory) {
        if (null != currentDSFactory) {
            currentDSFactory.destroy();
        }
        log.debug("Custom use [{}] datasource.", dsFactory.dataSourceName);
        currentDSFactory = dsFactory;
        return currentDSFactory;
    }

    private static DSFactory detectDSFactory(Setting setting) {
        DSFactory dsFactory;
        try {
            dsFactory = new TomcatDSFactory(setting);
        }
        catch (NoClassDefFoundError e1) {
            try {
                dsFactory = new HikariDSFactory(setting);
                log.debug("Use [{}] Datasource As Default", dsFactory.dataSourceName);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    dsFactory = new DruidDSFactory(setting);
                    log.debug("Use [{}] Datasource As Default", dsFactory.dataSourceName);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        dsFactory = new DbcpDSFactory(setting);
                        log.debug("Use [{}] Datasource As Default", dsFactory.dataSourceName);
                    }
                    catch (NoClassDefFoundError e4) {
                        try {
                            dsFactory = new C3p0DSFactory(setting);
                            log.debug("Use [{}] Datasource As Default", dsFactory.dataSourceName);
                        }
                        catch (NoClassDefFoundError e5) {
                            dsFactory = new PooledDSFactory(setting);
                            log.debug("Use [{}] Datasource As Default", dsFactory.dataSourceName);
                        }
                    }
                }
            }
        }
        return dsFactory;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (null != currentDSFactory) {
                    currentDSFactory.destroy();
                }
            }
        });
        lock = new Object();
    }
}

