/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert;

import com.xiaoleilu.hutool.convert.BasicType;
import com.xiaoleilu.hutool.convert.ConvertException;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.HexUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Convert {
    private Convert() {
    }

    public static String toStr(Object value, String defaultValue) {
        return Convert.convert(String.class, value, defaultValue);
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        return Convert.convert(Character.class, value, defaultValue);
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        return Convert.convert(Byte.class, value, defaultValue);
    }

    public static Byte toByte(Object value) {
        return Convert.toByte(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        return Convert.convert(Short.class, value, defaultValue);
    }

    public static Short toShort(Object value) {
        return Convert.toShort(value, null);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        return Convert.convert(Number.class, value, defaultValue);
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Convert.convert(Integer.class, value, defaultValue);
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(boolean isIgnoreConvertError, Object ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new Integer[0];
        }
        Integer[] ints = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer v = Convert.toInt(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ConvertException(StrUtil.format("Convert [{}] to Integer error!", values[i]));
            }
            ints[i] = v;
        }
        return ints;
    }

    public static Long toLong(Object value, Long defaultValue) {
        return Convert.convert(Long.class, value, defaultValue);
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Long[] toLongArray(boolean isIgnoreConvertError, Object ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new Long[0];
        }
        Long[] longs = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long v = Convert.toLong(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ConvertException(StrUtil.format("Convert [{}] to Long error!", values[i]));
            }
            longs[i] = v;
        }
        return longs;
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Convert.convert(Double.class, value, defaultValue);
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Double[] toDoubleArray(boolean isIgnoreConvertError, Object ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new Double[0];
        }
        Double[] doubles = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            Double v = Convert.toDouble(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ConvertException(StrUtil.format("Convert [{}] to Double error!", values[i]));
            }
            doubles[i] = v;
        }
        return doubles;
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return Convert.convert(Float.class, value, defaultValue);
    }

    public static Float toFloat(Object value) {
        return Convert.toFloat(value, null);
    }

    public static <T> Float[] toFloatArray(boolean isIgnoreConvertError, Object ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new Float[0];
        }
        Float[] floats = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            Float v = Convert.toFloat(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ConvertException(StrUtil.format("Convert [{}] to Float error!", values[i]));
            }
            floats[i] = v;
        }
        return floats;
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        return Convert.convert(Boolean.class, value, defaultValue);
    }

    public static Boolean toBool(Object value) {
        return Convert.toBool(value, null);
    }

    public static Boolean[] toBooleanArray(boolean isIgnoreConvertError, Object ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new Boolean[0];
        }
        Boolean[] bools = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            Boolean v = Convert.toBool(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ConvertException(StrUtil.format("Convert [{}] to Boolean error!", values[i]));
            }
            bools[i] = v;
        }
        return bools;
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        return Convert.convert(BigInteger.class, defaultValue, defaultValue);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        return Convert.convert(BigDecimal.class, defaultValue, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return (E)myE;
        }
        String valueStr = Convert.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return Convert.toEnum(clazz, value, null);
    }

    public static <T> T convert(Class<T> type, Object value) {
        return Convert.convert(type, value, null);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) {
        return ConverterRegistry.getInstance().convert(type, value, defaultValue);
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }

    public static String toHex(String str) {
        return HexUtil.encodeHexStr(str.getBytes());
    }

    public static String toHex(byte[] bytes) {
        return HexUtil.encodeHexStr(bytes);
    }

    public static byte[] hexToBytes(String src) {
        return HexUtil.decodeHex(src.toCharArray());
    }

    public static String hexStrToStr(String hexStr, Charset charset) {
        return HexUtil.decodeHexStr(hexStr, charset);
    }

    public static String strToUnicode(String strText) throws Exception {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < strText.length(); ++i) {
            char c;
            char intAsc = c = strText.charAt(i);
            String strHex = Integer.toHexString(intAsc);
            if (intAsc > '\u0080') {
                str.append("\\u" + strHex);
                continue;
            }
            str.append("\\u00" + strHex);
        }
        return str.toString();
    }

    public static String unicodeToStr(String hex) {
        int t = hex.length() / 6;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < t; ++i) {
            String s = hex.substring(i * 6, (i + 1) * 6);
            String s1 = s.substring(2, 4) + "00";
            String s2 = s.substring(4);
            int n = Integer.valueOf(s1, 16) + Integer.valueOf(s2, 16);
            char[] chars = Character.toChars(n);
            str.append(new String(chars));
        }
        return str.toString();
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StrUtil.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        return CharsetUtil.convert(str, sourceCharset, destCharset);
    }

    public long convertTime(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        Assert.isNull((Object)sourceUnit, "sourceUnit is null !");
        Assert.isNull((Object)destUnit, "destUnit is null !");
        return destUnit.convert(sourceDuration, sourceUnit);
    }

    public static String digitUppercase(double n) {
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        String s = "";
        for (int i = 0; i < fraction.length; ++i) {
            s = s + (digit[(int)(Math.floor(n * 10.0 * Math.pow(10.0, i)) % 10.0)] + fraction[i]).replaceAll("(\u96f6.)+", "");
        }
        if (s.length() < 1) {
            s = "\u6574";
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            String p = "";
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i] + s;
        }
        return head + s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }
}

