/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.FileUtil;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final Log log = StaticLog.get();

    public static File zip(String srcPath) throws IOException {
        return ZipUtil.zip(FileUtil.file(srcPath));
    }

    public static File zip(File srcFile) throws IOException {
        File zipFile = FileUtil.file(srcFile.getParentFile(), FileUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(srcFile, zipFile, false);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws IOException {
        return ZipUtil.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws IOException {
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.file(zipPath);
        ZipUtil.zip(srcFile, zipFile, withSrcDir);
        return zipFile;
    }

    public static void zip(File srcFile, File zipFile, boolean withSrcDir) throws IOException {
        ZipUtil.validateFile(srcFile, zipFile);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new CheckedOutputStream(FileUtil.getOutputStream(zipFile), new CRC32()));
            String srcRootDir = srcFile.getCanonicalPath();
            if (srcFile.isFile() || withSrcDir) {
                srcRootDir = srcFile.getParent();
            }
            ZipUtil.zip(srcRootDir, srcFile, out);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IoUtil.close(out);
                throw throwable;
            }
        }
        IoUtil.close(out);
    }

    public static File unzip(File zipFile) throws IOException {
        return ZipUtil.unzip(zipFile, FileUtil.file(zipFile.getParentFile(), FileUtil.mainName(zipFile)));
    }

    public static File unzip(String zipFilePath) throws IOException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath));
    }

    public static File unzip(String zipFilePath, String outFileDir) throws IOException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir(outFileDir));
    }

    public static File unzip(File zipFile, File outFile) throws IOException {
        ZipFile zipFileObj = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> em = zipFileObj.entries();
        ZipEntry zipEntry = null;
        File outItemFile = null;
        while (em.hasMoreElements()) {
            zipEntry = em.nextElement();
            outItemFile = new File(outFile, zipEntry.getName());
            log.debug("UNZIP {}", outItemFile.getPath());
            if (zipEntry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileUtil.touch(outItemFile);
            ZipUtil.copy(zipFileObj, zipEntry, outItemFile);
        }
        IoUtil.close(zipFileObj);
        return outFile;
    }

    public static byte[] gzip(String content, String charset) throws IOException {
        return ZipUtil.gzip(StrUtil.bytes(content, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] val) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(val.length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            gos.write(val, 0, val.length);
            gos.finish();
            gos.flush();
            val = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IoUtil.close(gos);
            throw throwable;
        }
        IoUtil.close(gos);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(File file) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            BufferedInputStream in = FileUtil.getInputStream(file);
            IoUtil.copy(in, gos);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IoUtil.close(gos);
            throw throwable;
        }
        IoUtil.close(gos);
        return byArray;
    }

    public static String unGzip(byte[] buf, String charset) throws IOException {
        return StrUtil.str(ZipUtil.unGzip(buf), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unGzip(byte[] buf) throws IOException {
        GZIPInputStream gzi = null;
        ByteArrayOutputStream bos = null;
        try {
            gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
            bos = new ByteArrayOutputStream(buf.length);
            IoUtil.copy(gzi, bos);
            buf = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IoUtil.close(gzi);
            throw throwable;
        }
        IoUtil.close(gzi);
        return buf;
    }

    private static void zip(String srcRootDir, File file, ZipOutputStream out) {
        block7: {
            block6: {
                if (file == null) {
                    return;
                }
                if (!file.isFile()) break block6;
                String subPath = FileUtil.subPath(srcRootDir, file);
                log.debug("ZIP {}", subPath);
                BufferedInputStream in = null;
                try {
                    out.putNextEntry(new ZipEntry(subPath));
                    in = FileUtil.getInputStream(file);
                    IoUtil.copy(in, out);
                }
                catch (IOException e) {
                    try {
                        throw new UtilException(e);
                    }
                    catch (Throwable throwable) {
                        IoUtil.close(in);
                        ZipUtil.closeEntry(out);
                        throw throwable;
                    }
                }
                IoUtil.close(in);
                ZipUtil.closeEntry(out);
                break block7;
            }
            for (File childFile : file.listFiles()) {
                ZipUtil.zip(srcRootDir, childFile, out);
            }
        }
    }

    private static void validateFile(File srcFile, File zipFile) throws UtilException {
        if (!srcFile.exists()) {
            throw new UtilException(StrUtil.format("File [{}] not exist!", srcFile.getAbsolutePath()));
        }
        try {
            if (srcFile.isDirectory() && zipFile.getParent().contains(srcFile.getCanonicalPath())) {
                throw new UtilException("[zipPath] must not be the child directory of [srcPath]!");
            }
            if (!zipFile.exists()) {
                FileUtil.touch(zipFile);
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IOException {
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            out = FileUtil.getOutputStream(outItemFile);
            IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            IoUtil.close(out);
            IoUtil.close(in);
            throw throwable;
        }
        IoUtil.close(out);
        IoUtil.close(in);
    }
}

