/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.lang.Conver;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;

public class IoUtil {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, writer, 1024);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        int readSize;
        char[] buffer = new char[bufferSize];
        long count = 0L;
        while ((readSize = reader.read(buffer, 0, bufferSize)) >= 0) {
            writer.write(buffer, 0, readSize);
            count += (long)readSize;
            writer.flush();
        }
        return count;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IoUtil.copy(in, out, 1024);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = -1;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
            count += (long)n;
            out.flush();
        }
        return count;
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        return inChannel.transferTo(0L, inChannel.size(), outChannel);
    }

    public static BufferedReader getReader(InputStream in, String charsetName) throws IOException {
        return IoUtil.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) throws IOException {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null;
        reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out.toByteArray();
    }

    public static String read(InputStream in, String charset) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out.toString(charset);
    }

    public static String read(Reader reader) throws IOException {
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(1024);
        while (-1 != reader.read(buffer)) {
            builder.append(buffer.flip().toString());
        }
        return builder.toString();
    }

    public static String read(FileChannel fileChannel, String charset) throws IOException {
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        return StrUtil.str((ByteBuffer)buffer, charset);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, String charset, T collection) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        String line = null;
        while ((line = reader.readLine()) != null) {
            collection.add((String)line);
        }
        return collection;
    }

    public static ByteArrayInputStream toStream(String content, String charset) {
        if (content == null) {
            return null;
        }
        byte[] data = null;
        try {
            data = StrUtil.isBlank(charset) ? content.getBytes() : content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Invalid charset [{}] !", charset), e);
        }
        return new ByteArrayInputStream(data);
    }

    public static void write(OutputStream out, String charset, boolean isCloseOut, Object ... contents) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Conver.toStr(content, ""));
                osw.flush();
            }
        }
        catch (Exception e) {
            throw new IOException("Write content to OutputStream error!", e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(osw);
            }
        }
    }

    public static void echo(Object content, Object ... param) {
        if (content == null) {
            System.out.println(content);
        }
        System.out.println(StrUtil.format(content.toString(), param));
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

