/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.util.StrUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(Logger.getLogger(clazz));
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.logger.trace((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.logger.trace((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.logger.debug((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.logger.debug((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.logger.info((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.logger.info((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.logger.warn((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.logger.warn((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.logger.error((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.logger.warn((Object)StrUtil.format(format, arguments), t);
        }
    }
}

