/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.http.HttpRequest;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.FileUtil;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.ReUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*?)\"");

    public static String encode(String content, Charset charset) {
        return HttpUtil.encode(content, charset.name());
    }

    public static String encode(String content, String charsetStr) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charsetStr), e);
        }
        return encodeContent;
    }

    public static String decode(String content, Charset charset) {
        return HttpUtil.decode(content, charset.name());
    }

    public static String decode(String content, String charsetStr) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charsetStr), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String ip;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP"};
        if (CollectionUtil.isNotEmpty(otherHeaderNames)) {
            headers = CollectionUtil.addAll(headers, otherHeaderNames);
        }
        for (String header : headers) {
            ip = request.getHeader(header);
            if (HttpUtil.isUnknow(ip)) continue;
            return HttpUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return HttpUtil.getMultistageReverseProxyIp(ip);
    }

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static String get(String urlString, String customCharset) throws IOException {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String get(String urlString) throws IOException {
        return HttpRequest.get(urlString).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) throws IOException {
        return HttpRequest.post(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, String params) throws IOException {
        return HttpRequest.post(urlString).body(params).execute().body();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadString(String url, String customCharset) throws IOException {
        String string;
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            string = IoUtil.read(in, customCharset);
        }
        catch (Throwable throwable) {
            IoUtil.close(in);
            throw throwable;
        }
        IoUtil.close(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long downloadFile(String url, File destFile) throws IOException {
        long l;
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new URL(url).openStream();
            out = FileUtil.getOutputStream(destFile);
            l = IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            IoUtil.close(in);
            IoUtil.close(out);
            throw throwable;
        }
        IoUtil.close(in);
        IoUtil.close(out);
        return l;
    }

    public static String toParams(Map<String, Object> paramMap) {
        if (CollectionUtil.isEmpty(paramMap)) {
            return "";
        }
        return CollectionUtil.join(paramMap.entrySet(), "&");
    }

    public static String toParams(Map<String, Object> paramMap, String charset) {
        if (CollectionUtil.isEmpty(paramMap)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append(HttpUtil.encode(item.getKey(), charset)).append("=").append(HttpUtil.encode(item.getValue().toString(), charset));
        }
        return sb.toString();
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StrUtil.isBlank(paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > 0) {
            paramsStr = StrUtil.subSuf(paramsStr, pathEndPos + 1);
        }
        paramsStr = HttpUtil.decode(paramsStr, charset);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        for (i = 0; i < paramsStr.length(); ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "");
        }
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form) {
        String queryString = HttpUtil.toParams(form);
        return HttpUtil.urlWithForm(url, queryString);
    }

    public static String urlWithForm(String url, String queryString) {
        if (StrUtil.isNotBlank(queryString)) {
            if (url.contains("?")) {
                url = url + "&" + queryString;
            }
            url = url + (url.endsWith("?") ? queryString : "?" + queryString);
        }
        return url;
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        String charset = conn.getContentEncoding();
        if (StrUtil.isBlank(charset)) {
            charset = ReUtil.get(CHARSET_PATTERN, conn.getContentType(), 1);
        }
        return charset;
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (HttpUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getString(InputStream in, String charset, boolean isGetCharsetFromContent) throws IOException {
        if (!isGetCharsetFromContent) {
            return IoUtil.read(in, charset);
        }
        StringBuilder content = new StringBuilder();
        BufferedReader reader = IoUtil.getReader(in, charset);
        String line = null;
        while ((line = reader.readLine()) != null) {
            content.append(line).append('\n');
            String charsetInContent = ReUtil.get(CHARSET_PATTERN, line, 1);
            if (!StrUtil.isNotBlank(charsetInContent)) continue;
            charset = charsetInContent;
            reader = IoUtil.getReader(in, charset);
            isGetCharsetFromContent = false;
        }
        return content.toString();
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }
}

