/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.xiaoleilu.hutool.db.ds.druid.SettingDruidDataSource;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.IoUtil;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DruidDS {
    private static final Log log = StaticLog.get();
    private static Setting dbSetting;
    private static Setting druidSetting;
    private static Map<String, DruidDataSource> dsMap;

    public static synchronized void init(Setting druid_setting, Setting db_setting) {
        dsMap = new HashMap<String, DruidDataSource>();
        druidSetting = druid_setting;
        if (druidSetting == null) {
            try {
                druidSetting = new Setting("config/druid.setting", "utf8", true);
            }
            catch (Exception e) {
                log.info("Druid setting file {} not found.", "config/druid.setting");
            }
        }
        if ((dbSetting = db_setting) == null) {
            try {
                dbSetting = new Setting("config/db.setting", "utf8", true);
            }
            catch (Exception e) {
                log.info("No default DB config file {} found, custom to init it.", "config/db.setting");
            }
        }
    }

    public static synchronized DruidDataSource getDataSource(String group) {
        DruidDataSource existedDataSource;
        if (null == dsMap) {
            DruidDS.init(null, null);
        }
        if (dbSetting == null) {
            throw new UtilException("No setting found, please init it!");
        }
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = dsMap.get(group)) != null) {
            return existedDataSource;
        }
        SettingDruidDataSource dds = new SettingDruidDataSource(druidSetting, dbSetting, group);
        dsMap.put(group, dds);
        return dds;
    }

    public static DruidDataSource getDataSource() {
        return DruidDS.getDataSource(null);
    }

    public static Connection getConnection(String datasource) throws SQLException {
        return DruidDS.getDataSource(datasource).getConnection();
    }

    public static Connection getConnection() throws SQLException {
        return DruidDS.getConnection(null);
    }

    public static synchronized void closeDs(String dsName) {
        DruidDataSource dds;
        if (dsName == null) {
            dsName = "";
        }
        if ((dds = dsMap.get(dsName)) != null) {
            IoUtil.close((Closeable)dds);
            dsMap.remove(dsName);
        }
    }

    public static synchronized void closeDs() {
        DruidDS.closeDs(null);
    }

    public static synchronized void closeAll() {
        Collection<DruidDataSource> values = dsMap.values();
        for (DruidDataSource dds : values) {
            if (dds == null) continue;
            dds.close();
        }
        dsMap.clear();
    }
}

