/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.PageResult;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import com.xiaoleilu.hutool.db.sql.SqlExecutor;
import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class Session
implements Closeable {
    private static final Log log = StaticLog.get();
    private Connection conn = null;
    private SqlConnRunner runner = null;
    private Boolean isSupportTransaction = null;

    public static Session create(DataSource ds) {
        return new Session(ds);
    }

    public static Session create(Connection conn) {
        return new Session(conn);
    }

    public Session(DataSource ds) {
        try {
            this.conn = ds.getConnection();
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Get connection error!", e);
        }
        this.runner = new SqlConnRunner(DialectFactory.newDialect(this.conn));
    }

    public Session(Connection conn) {
        this.conn = conn;
        this.runner = new SqlConnRunner(DialectFactory.newDialect(conn));
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public SqlConnRunner getRunner() {
        return this.runner;
    }

    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }

    public void beginTransaction() throws SQLException {
        if (null == this.isSupportTransaction) {
            this.isSupportTransaction = this.conn.getMetaData().supportsTransactions();
        } else if (!this.isSupportTransaction.booleanValue()) {
            throw new SQLException("Transaction not supported for current database!");
        }
        this.conn.setAutoCommit(false);
    }

    public void commit() throws SQLException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.conn.setAutoCommit(true);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.conn.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quietRollback() {
        try {
            this.conn.rollback();
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.conn.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quietRollback(Savepoint savepoint) throws SQLException {
        try {
            this.conn.rollback(savepoint);
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (!this.conn.getMetaData().supportsTransactionIsolationLevel(level)) {
            throw new SQLException(StrUtil.format("Transaction isolation [{}] not support!", level));
        }
        this.conn.setTransactionIsolation(level);
    }

    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        return SqlExecutor.query(this.conn, sql, rsh, params);
    }

    public int execute(String sql, Object ... params) throws SQLException {
        return SqlExecutor.execute(this.conn, sql, params);
    }

    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        return SqlExecutor.executeForGeneratedKey(this.conn, sql, params);
    }

    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        return SqlExecutor.executeBatch(this.conn, sql, paramsBatch);
    }

    public int insert(Entity record) throws SQLException {
        return this.runner.insert(this.conn, record);
    }

    public int[] insert(Collection<Entity> records) throws SQLException {
        return this.runner.insert(this.conn, records);
    }

    public List<Object> insertForGeneratedKeys(Entity record) throws SQLException {
        return this.runner.insertForGeneratedKeys(this.conn, record);
    }

    public Long insertForGeneratedKey(Entity record) throws SQLException {
        return this.runner.insertForGeneratedKey(this.conn, record);
    }

    public int del(Entity where) throws SQLException {
        return this.runner.del(this.conn, where);
    }

    public int update(Entity record, Entity where) throws SQLException {
        return this.runner.update(this.conn, record, where);
    }

    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        return this.runner.find(this.conn, fields, where, rsh);
    }

    public int count(Entity where) throws SQLException {
        return this.runner.count(this.conn, where);
    }

    public <T> T page(Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        return this.runner.page(this.conn, fields, where, page, numPerPage, rsh);
    }

    public <T> T page(Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        return this.runner.page(this.conn, fields, where, page, rsh);
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        return this.runner.page(this.conn, fields, where, page, numPerPage);
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, Page page) throws SQLException {
        return this.runner.page(this.conn, fields, where, page);
    }

    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        return this.runner.page(this.conn, where, page);
    }

    @Override
    public void close() {
        DbUtil.close(this.conn);
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

