/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import com.xiaoleilu.hutool.lang.Dict;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private List<String> fieldNames;

    public static Entity create() {
        return new Entity();
    }

    public static Entity create(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity parse(T bean) {
        return Entity.create(null).parseBean((Object)bean);
    }

    public Entity() {
    }

    public Entity(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Entity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Entity setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    public Entity setFieldNames(String ... fieldNames) {
        this.fieldNames = Arrays.asList(fieldNames);
        return this;
    }

    public Entity addFieldNames(String ... fieldNames) {
        List<String> fieldList = Arrays.asList(fieldNames);
        if (null == this.fieldNames) {
            this.fieldNames = fieldList;
        } else {
            this.fieldNames.addAll(fieldList);
        }
        return this;
    }

    @Override
    public <T> Entity parseBean(T bean) {
        String tableName = bean.getClass().getSimpleName();
        tableName = StrUtil.lowerFirst(tableName);
        this.setTableName(tableName);
        return (Entity)super.parseBean(bean);
    }

    @Override
    public Object put(String key, Object value) {
        if (CollectionUtil.isEmpty(this.fieldNames) || this.fieldNames.contains(key)) {
            super.put(key, value);
        }
        return super.put(key, value);
    }

    @Override
    public Entity set(String attr, Object value) {
        return (Entity)super.set(attr, value);
    }

    @Override
    public Entity setIgnoreNull(String attr, Object value) {
        return (Entity)super.setIgnoreNull(attr, value);
    }

    public Clob getClob(String attr) {
        return this.get(attr, null);
    }

    @Override
    public String getStr(String attr) {
        Object obj = this.get(attr);
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            Reader reader = null;
            try {
                reader = clob.getCharacterStream();
                String string = IoUtil.read(reader);
                return string;
            }
            catch (IOException | SQLException e) {
                throw new DbRuntimeException(e);
            }
            finally {
                IoUtil.close(reader);
            }
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StrUtil.str(rowId.getBytes(), "UTF-8");
        }
        return super.getStr(attr);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    public RowId getRowId(String attr) {
        Object obj = this.get(attr);
        if (null == obj) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw new DbRuntimeException("Value with name [{}] is not a rowid!", attr);
    }

    @Override
    public Entity clone() {
        return (Entity)super.clone();
    }

    @Override
    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }
}

