/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.setting;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.setting.IBasicSetting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;

public abstract class AbsSetting
implements IBasicSetting {
    protected Charset charset;
    protected boolean isUseVariable;
    protected URL settingUrl;

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public abstract String getStr(String var1);

    @Override
    public String getStr(String key, String defaultValue) {
        String value = this.getStr(key);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    @Override
    public Integer getInt(String key, Integer defaultValue) {
        return Conver.toInt(this.getStr(key), defaultValue);
    }

    @Override
    public Short getShort(String key) {
        return this.getShort(key, null);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return Conver.toShort(this.getStr(key), defaultValue);
    }

    @Override
    public Boolean getBool(String key) {
        return this.getBool(key, null);
    }

    @Override
    public Boolean getBool(String key, Boolean defaultValue) {
        return Conver.toBool(this.getStr(key), defaultValue);
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return Conver.toLong(this.getStr(key), defaultValue);
    }

    @Override
    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    @Override
    public Character getChar(String key, Character defaultValue) {
        return Conver.toChar(this.getStr(key), defaultValue);
    }

    @Override
    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return Conver.toDouble(this.getStr(key), defaultValue);
    }

    @Override
    public Byte getByte(String key) {
        return this.getByte(key, null);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return Conver.toByte(this.getStr(key), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

