/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.SqlExecutor;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class SqlRunner {
    protected SqlConnRunner runner;
    private DataSource ds;

    public static SqlRunner create(DataSource ds) {
        return ds == null ? null : new SqlRunner(ds);
    }

    public static SqlRunner create(DataSource ds, Dialect dialect) {
        return new SqlRunner(ds, dialect);
    }

    public static SqlRunner create(DataSource ds, String driverClassName) {
        return new SqlRunner(ds, DialectFactory.newDialect(driverClassName));
    }

    public SqlRunner(DataSource ds) {
        this(ds, DialectFactory.newDialect(ds));
    }

    public SqlRunner(DataSource ds, Dialect dialect) {
        this.runner = new SqlConnRunner(dialect);
        this.ds = ds;
    }

    public SqlRunner(DataSource ds, String driverClassName) {
        this.runner = new SqlConnRunner(driverClassName);
        this.ds = ds;
    }

    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = SqlExecutor.query(conn, sql, rsh, params);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public int execute(String sql, Object ... params) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = SqlExecutor.execute(conn, sql, params);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        Long l;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            l = SqlExecutor.executeForGeneratedKey(conn, sql, params);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return l;
    }

    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        int[] nArray;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return nArray;
    }

    public int insert(Entity record) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.runner.insert(conn, record);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public int[] insert(Collection<Entity> records) throws SQLException {
        int[] nArray;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            nArray = this.runner.insert(conn, records);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return nArray;
    }

    public List<Object> insertForGeneratedKeys(Entity record) throws SQLException {
        List<Object> list;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            list = this.runner.insertForGeneratedKeys(conn, record);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return list;
    }

    public Long insertForGeneratedKey(Entity record) throws SQLException {
        Long l;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            l = this.runner.insertForGeneratedKey(conn, record);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return l;
    }

    public int del(Entity where) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.runner.del(conn, where);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public int update(Entity record, Entity where) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.runner.update(conn, record, where);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = this.runner.find(conn, fields, where, rsh);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public <T> T find(Entity where, RsHandler<T> rsh) throws SQLException {
        return this.find(null, where, rsh);
    }

    public <T> T page(Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = this.runner.page(conn, fields, where, page, numPerPage, rsh);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public int count(Entity where) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.runner.count(conn, where);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public SqlConnRunner getRunner() {
        return this.runner;
    }

    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }
}

