/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.db.Dict;
import java.util.Arrays;
import java.util.List;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private List<String> fieldNames;

    public static Entity create(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity parse(T vo) {
        return Entity.create(null).fromVo((Object)vo);
    }

    public Entity() {
    }

    public Entity(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Entity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Entity setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    public Entity setFieldNames(String ... fieldNames) {
        this.fieldNames = Arrays.asList(fieldNames);
        return this;
    }

    public Entity addFieldNames(String ... fieldNames) {
        List<String> fieldList = Arrays.asList(fieldNames);
        if (null == this.fieldNames) {
            this.fieldNames = fieldList;
        } else {
            this.fieldNames.addAll(fieldList);
        }
        return this;
    }

    @Override
    public <T> Entity fromVo(T vo) {
        String tableName = vo.getClass().getSimpleName();
        tableName = StrUtil.lowerFirst(tableName);
        this.setTableName(tableName);
        return (Entity)super.fromVo(vo);
    }

    @Override
    public Object put(String key, Object value) {
        if (CollectionUtil.isEmpty(this.fieldNames) || this.fieldNames.contains(key)) {
            super.put(key, value);
        }
        return super.put(key, value);
    }

    @Override
    public Entity set(String attr, Object value) {
        return (Entity)super.set(attr, value);
    }

    @Override
    public Entity setIgnoreNull(String attr, Object value) {
        return (Entity)super.setIgnoreNull(attr, value);
    }

    @Override
    public Entity clone() {
        return (Entity)super.clone();
    }

    @Override
    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }
}

