/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.InjectUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Dict
extends HashMap<String, Object> {
    private static final long serialVersionUID = 6135423866861206530L;

    public static Dict create() {
        return new Dict();
    }

    public static <T> Dict parse(T vo) {
        return Dict.create().fromVo(vo);
    }

    public <T> Dict fillVo(T vo) {
        InjectUtil.injectFromMap(vo, this);
        return this;
    }

    public <T> T toVo(Class<T> clazz, boolean ignoreCase) {
        T vo;
        if (clazz == null) {
            throw new NullPointerException("Provided Class is null!");
        }
        try {
            vo = clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance Value Object [] error!", clazz.getName()));
        }
        if (ignoreCase) {
            InjectUtil.injectFromMapIgnoreCase(vo, this);
        } else {
            InjectUtil.injectFromMap(vo, this);
        }
        return vo;
    }

    public <T> T toVo(Class<T> clazz) {
        return this.toVo(clazz, false);
    }

    public <T> T toVoIgnoreCase(Class<T> clazz) {
        return this.toVo(clazz, true);
    }

    public <T> Dict fromVo(T vo) {
        this.putAll(InjectUtil.toMap(vo, false));
        return this;
    }

    public <T extends Dict> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = new HashSet<String>();
        for (String name : withoutNames) {
            withoutSet.add(name);
        }
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dict setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        return Conver.toStr(this.get(attr), null);
    }

    public Integer getInt(String attr) {
        return Conver.toInt(this.get(attr), null);
    }

    public Long getLong(String attr) {
        return Conver.toLong(this.get(attr), null);
    }

    public Float getFloat(String attr) {
        return Conver.toFloat(this.get(attr), null);
    }

    public Boolean getBool(String attr) {
        return Conver.toBool(this.get(attr), null);
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    public BigDecimal getBigDecimal(String attr) {
        return this.get(attr, null);
    }

    public BigInteger getBigInteger(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Dict clone() {
        return (Dict)super.clone();
    }
}

