/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.SqlRunner;
import com.xiaoleilu.hutool.db.handler.EntityHandler;
import com.xiaoleilu.hutool.db.handler.EntityListHandler;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class DaoTemplate {
    protected SqlRunner runner;
    protected String tableName;
    protected String primaryKeyField = "id";

    public DaoTemplate(String tableName) {
        this.tableName = tableName;
    }

    public DaoTemplate(String tableName, String primaryKeyField) {
        this.tableName = tableName;
        this.primaryKeyField = primaryKeyField;
    }

    public DaoTemplate(String tableName, String primaryKeyField, DataSource ds) {
        this(tableName, primaryKeyField, DbUtil.newSqlRunner(ds));
    }

    public DaoTemplate(String tableName, String primaryKeyField, SqlRunner runner) {
        this.tableName = tableName;
        this.primaryKeyField = primaryKeyField;
        this.runner = runner;
    }

    public int add(Entity entity) throws SQLException {
        if (StrUtil.isBlank(entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return this.runner.insert(entity);
    }

    public List<Object> addForGeneratedKeys(Entity entity) throws SQLException {
        if (StrUtil.isBlank(entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return this.runner.insertForGeneratedKeys(entity);
    }

    public Long addForGeneratedKey(Entity entity) throws SQLException {
        if (StrUtil.isBlank(entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return this.runner.insertForGeneratedKey(entity);
    }

    public <T> int del(T pk) throws SQLException {
        if (pk == null) {
            return 0;
        }
        return this.del(Entity.create(this.tableName).set(this.primaryKeyField, pk));
    }

    public <T> int del(String field, T value) throws SQLException {
        if (StrUtil.isBlank(field)) {
            return 0;
        }
        return this.del(Entity.create(this.tableName).set(field, value));
    }

    public <T> int del(Entity where) throws SQLException {
        if (CollectionUtil.isEmpty(where)) {
            return 0;
        }
        if (StrUtil.isBlank(where.getTableName())) {
            where.setTableName(this.tableName);
        }
        return this.runner.del(where);
    }

    public int update(Entity entity) throws SQLException {
        entity.setTableName(this.tableName);
        Object pk = entity.get(this.primaryKeyField);
        if (null == pk) {
            throw new SQLException(StrUtil.format("Please determine `{}` for update", this.primaryKeyField));
        }
        Entity where = Entity.create(this.tableName).set(this.primaryKeyField, pk);
        Entity record = entity.clone();
        record.remove(this.primaryKeyField);
        return this.runner.update(record, where);
    }

    public int addOrUpdate(Entity entity) throws SQLException {
        if (entity.get(this.primaryKeyField) == null) {
            entity.set(this.primaryKeyField, this.add(entity));
            return 1;
        }
        return this.update(entity);
    }

    public <T> Entity get(T pk) throws SQLException {
        return this.get(this.primaryKeyField, pk);
    }

    public <T> Entity get(String field, T value) throws SQLException {
        return this.get(Entity.create(this.tableName).set(field, value));
    }

    public Entity get(Entity where) throws SQLException {
        if (null == where) {
            where = Entity.create(this.tableName);
        }
        if (StrUtil.isBlank(where.getTableName())) {
            where.setTableName(this.tableName);
        }
        return this.runner.find(null, where, new EntityHandler());
    }

    public <T> List<Entity> find(String field, T value) throws SQLException {
        return this.find(Entity.create(this.tableName).set(field, value));
    }

    public List<Entity> findAll() throws SQLException {
        return this.find(Entity.create(this.tableName));
    }

    public List<Entity> find(Entity where) throws SQLException {
        return this.runner.find(null, where, new EntityListHandler());
    }

    public int count(Entity where) throws SQLException {
        return this.runner.count(where);
    }

    public boolean exist(Entity where) throws SQLException {
        return this.count(where) > 0;
    }
}

