/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Func;
import com.xiaoleilu.hutool.ReUtil;
import com.xiaoleilu.hutool.StrUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class Validator {
    public static final Pattern GENERAL = Pattern.compile("^\\w+$");
    public static final Pattern NUMBER = Pattern.compile("\\d+");
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)");
    public static final Pattern IPV4 = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    public static final Pattern MONEY = Pattern.compile("^(\\d+(?:\\.\\d+)?)$");
    public static final Pattern EMAIL = Pattern.compile("(\\w|.)+@\\w+(\\.\\w+){1,2}");
    public static final Pattern MOBILE = Pattern.compile("1\\d{10}");
    public static final Pattern CITIZEN_ID = Pattern.compile("[1-9]\\d{5}[1-2]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}(\\d|X|x)");
    public static final Pattern ZIP_CODE = Pattern.compile("\\d{6}");
    public static final Pattern BIRTHDAY = Pattern.compile("(\\d{4})(/|-|\\.)(\\d{1,2})(/|-|\\.)(\\d{1,2})\u65e5?$");
    public static final Pattern URL = Pattern.compile("(https://|http://)?([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?");
    public static final Pattern GENERAL_WITH_CHINESE = Pattern.compile("^[\\u0391-\\uFFE5\\w]+$");
    public static final Pattern UUID = Pattern.compile("^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$");

    public static <T> boolean isEmpty(T value) {
        return null == value || value instanceof String && StrUtil.isEmpty((String)value);
    }

    public static boolean equals(Object t1, Object t2) {
        return Func.equals(t1, t2);
    }

    public static boolean isByRegex(String regex, String value) {
        return ReUtil.isMatch(regex, value);
    }

    public static boolean isByRegex(Pattern pattern, String value) {
        return ReUtil.isMatch(pattern, value);
    }

    public static boolean isGeneral(String value) {
        return Validator.isByRegex(GENERAL, value);
    }

    public static boolean isGeneral(String value, int min, int max) {
        String reg = "^\\w{" + min + "," + max + "}$";
        if (min < 0) {
            min = 0;
        }
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isByRegex(reg, value);
    }

    public static boolean isGeneral(String value, int min) {
        return Validator.isGeneral(value, min, 0);
    }

    public static boolean isNumber(String value) {
        if (StrUtil.isBlank(value)) {
            return false;
        }
        return Validator.isByRegex(NUMBER, value);
    }

    public static boolean isMoney(String value) {
        return Validator.isByRegex(MONEY, value);
    }

    public static boolean isZipCode(String value) {
        return Validator.isByRegex(ZIP_CODE, value);
    }

    public static boolean isEmail(String value) {
        return Validator.isByRegex(EMAIL, value);
    }

    public static boolean isMobile(String value) {
        return Validator.isByRegex(MOBILE, value);
    }

    public static boolean isCitizenId(String value) {
        return Validator.isByRegex(CITIZEN_ID, value);
    }

    public static boolean isBirthday(String value) {
        if (Validator.isByRegex(BIRTHDAY, value)) {
            int year = Integer.parseInt(value.substring(0, 4));
            int month = Integer.parseInt(value.substring(5, 7));
            int day = Integer.parseInt(value.substring(8, 10));
            if (month < 1 || month > 12) {
                return false;
            }
            if (day < 1 || day > 31) {
                return false;
            }
            if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
                return false;
            }
            if (month == 2) {
                boolean isleap;
                boolean bl = isleap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
                if (day > 29 || day == 29 && !isleap) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isIpv4(String value) {
        return Validator.isByRegex(IPV4, value);
    }

    public static boolean isUrl(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static boolean isChinese(String value) {
        return Validator.isByRegex("^[\u4e00-\u9fff]+$", value);
    }

    public static boolean isGeneralWithChinese(String value) {
        return Validator.isByRegex(GENERAL_WITH_CHINESE, value);
    }

    public static boolean isUUID(String value) {
        return Validator.isByRegex(UUID, value);
    }
}

