/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.setting.dialect.BasicSetting;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;

public class Setting
extends BasicSetting {
    private static Logger log = Log.get();

    public Setting(Charset charset, boolean isUseVariable) {
        super(charset, isUseVariable);
    }

    public Setting(String pathBaseClassLoader, String charset, boolean isUseVariable) {
        super(pathBaseClassLoader, charset, isUseVariable);
    }

    public Setting(File configFile, String charset, boolean isUseVariable) {
        super(configFile, charset, isUseVariable);
    }

    public Setting(String path, Class<?> clazz, String charset, boolean isUseVariable) {
        super(path, clazz, charset, isUseVariable);
    }

    public Setting(URL url, String charset, boolean isUseVariable) {
        super(url, charset, isUseVariable);
    }

    public Setting(String pathBaseClassLoader) {
        super(pathBaseClassLoader);
    }

    public String getWithLog(String key) {
        return this.get(key, null);
    }

    public String getWithLog(String key, String group) {
        String value = this.get(key, group);
        if (value == null) {
            log.debug("No key define for [{}]!", (Object)key);
        }
        return value;
    }

    public String get(String key, String group) {
        return super.getByGroup(key, group);
    }

    public String getString(String key) {
        return super.getStr(key);
    }

    public String getStringWithDefault(String key, String defaultValue) {
        return super.getStr(key, defaultValue);
    }

    public String getString(String key, String group) {
        return super.getByGroup(key, group);
    }

    public String getStringWithDefault(String key, String group, String defaultValue) {
        String value = this.getString(key, group);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, ",");
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getString(key, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return StrUtil.split(value, delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Conver.toInt(this.get(key, group), defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Conver.toBool(this.get(key, group), defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Conver.toLong(this.get(key, group), defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.get(key, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Conver.toDouble(this.get(key, group), defaultValue);
    }
}

