/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;

public class InjectUtil {
    private InjectUtil() {
    }

    public static <T> void injectFromRequest(T model, ServletRequest request, boolean isWithModelName) {
        InjectUtil.injectFromRequest(model, model.getClass().getSimpleName(), request, isWithModelName);
    }

    public static <T> void injectFromRequest(T model, String modelName, ServletRequest request, boolean isWithModelName) {
        Method[] methods;
        for (Method method : methods = model.getClass().getMethods()) {
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || (types = method.getParameterTypes()).length != 1) continue;
            String fieldName = StrUtil.getGeneralField(methodName);
            String paramName = isWithModelName ? modelName + "." + fieldName : fieldName;
            String value = request.getParameter(paramName);
            if (StrUtil.isEmpty(value)) continue;
            try {
                method.invoke(model, Conver.parse(types[0], value));
            }
            catch (Exception e) {
                throw new UtilException(StrUtil.format("Inject [{}] error!", paramName), e);
            }
        }
    }

    public static <T> void injectFromMapIgnoreCase(T model, Map<?, ?> map) {
        HashMap map2 = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                String keyStr = (String)key;
                map2.put(keyStr.toLowerCase(), entry.getValue());
                continue;
            }
            map2.put((String)key, entry.getValue());
        }
        InjectUtil.injectFromMap(model, map2);
    }

    public static <T> void injectFromMap(T model, Map<?, ?> map) {
        Method[] methods;
        for (Method method : methods = model.getClass().getMethods()) {
            String fieldName;
            Object value;
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || (types = method.getParameterTypes()).length != 1 || (value = map.get(fieldName = StrUtil.getGeneralField(methodName))) == null) continue;
            try {
                method.invoke(model, Conver.parse(types[0], value));
            }
            catch (Exception e) {
                throw new UtilException(StrUtil.format("Inject [{}] error!", fieldName), e);
            }
        }
    }

    public static <T> Map<String, Object> toMap(T model, boolean isOnlyBasicType) {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method method : methods = model.getClass().getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get")) continue;
            String fieldName = StrUtil.getGeneralField(methodName);
            Object value = null;
            try {
                value = method.invoke(model, new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(StrUtil.format("Inject map [{}] error!", fieldName), e);
            }
            if (value == null || !(value instanceof String) && !value.getClass().isPrimitive() && isOnlyBasicType) continue;
            map.put(fieldName, value);
        }
        return map;
    }
}

