/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.DateTime;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;

public class DateUtil {
    public static final long MS = 1L;
    public static final long SECOND_MS = 1000L;
    public static final long MINUTE_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static ThreadLocal<SimpleDateFormat> NORM_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.NORM_DATE_PATTERN);
        }
    };
    private static ThreadLocal<SimpleDateFormat> NORM_TIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.NORM_TIME_PATTERN);
        }
    };
    private static ThreadLocal<SimpleDateFormat> NORM_DATETIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.NORM_DATETIME_PATTERN);
        }
    };
    private static ThreadLocal<SimpleDateFormat> HTTP_DATETIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.HTTP_DATETIME_PATTERN, Locale.US);
        }
    };

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static int month(Date date) {
        return DateUtil.toCalendar(date).get(2) + 1;
    }

    public static int year(Date date) {
        return DateUtil.toCalendar(date).get(1);
    }

    public static int season(Date date) {
        return DateUtil.toCalendar(date).get(2) / 3 + 1;
    }

    public static String yearAndSeason(Date date) {
        return DateUtil.yearAndSeason(DateUtil.toCalendar(date));
    }

    public static LinkedHashSet<String> yearAndSeasons(Date startDate, Date endDate) {
        LinkedHashSet<String> seasons = new LinkedHashSet<String>();
        if (startDate == null || endDate == null) {
            return seasons;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (true) {
            if (startDate.after(endDate)) {
                startDate = endDate;
            }
            seasons.add(DateUtil.yearAndSeason(cal));
            if (startDate.equals(endDate)) break;
            cal.add(2, 3);
            startDate = cal.getTime();
        }
        return seasons;
    }

    public static String format(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDateTime(Date date) {
        return NORM_DATETIME_FORMAT.get().format(date);
    }

    public static String formatDate(Date date) {
        return NORM_DATE_FORMAT.get().format(date);
    }

    public static String formatHttpDate(Date date) {
        return HTTP_DATETIME_FORMAT.get().format(date);
    }

    public static DateTime parse(String dateStr, SimpleDateFormat simpleDateFormat) {
        try {
            return new DateTime(simpleDateFormat.parse(dateStr));
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Parse [{}] with format [{}] error!", dateStr, simpleDateFormat.toPattern()), e);
        }
    }

    public static DateTime parse(String dateString, String format) {
        return DateUtil.parse(dateString, new SimpleDateFormat(format));
    }

    public static DateTime parseDateTime(String dateString) {
        return DateUtil.parse(dateString, NORM_DATETIME_FORMAT.get());
    }

    public static DateTime parseDate(String dateString) {
        return DateUtil.parse(dateString, NORM_DATE_FORMAT.get());
    }

    public static DateTime parseTime(String timeString) {
        return DateUtil.parse(timeString, NORM_TIME_FORMAT.get());
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        dateStr = dateStr.trim();
        int length = dateStr.length();
        try {
            if (length == NORM_DATETIME_PATTERN.length()) {
                return DateUtil.parseDateTime(dateStr);
            }
            if (length == NORM_DATE_PATTERN.length()) {
                return DateUtil.parseDate(dateStr);
            }
            if (length == NORM_TIME_PATTERN.length()) {
                return DateUtil.parseTime(dateStr);
            }
            if (length == NORM_DATETIME_MINUTE_PATTERN.length()) {
                return DateUtil.parse(dateStr, NORM_DATETIME_MINUTE_PATTERN);
            }
            if (length >= NORM_DATETIME_MS_PATTERN.length() - 2) {
                return DateUtil.parse(dateStr, NORM_DATETIME_MS_PATTERN);
            }
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Parse [{}] with format normal error!", dateStr));
        }
        throw new UtilException(StrUtil.format(" [{}] format is not fit for date pattern!", dateStr));
    }

    public static DateTime getBeginTimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new DateTime(calendar.getTime());
    }

    public static DateTime getEndTimeOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new DateTime(calendar.getTime());
    }

    public static DateTime yesterday() {
        return DateUtil.offsiteDay(new DateTime(), -1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsiteWeek(new DateTime(), -1);
    }

    public static DateTime lastMouth() {
        return DateUtil.offsiteMonth(new DateTime(), -1);
    }

    public static DateTime offsiteDay(Date date, int offsite) {
        return DateUtil.offsiteDate(date, 6, offsite);
    }

    public static DateTime offsiteWeek(Date date, int offsite) {
        return DateUtil.offsiteDate(date, 3, offsite);
    }

    public static DateTime offsiteMonth(Date date, int offsite) {
        return DateUtil.offsiteDate(date, 2, offsite);
    }

    public static DateTime offsiteDate(Date date, int calendarField, int offsite) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(calendarField, offsite);
        return new DateTime(cal.getTime());
    }

    public static long diff(Date subtrahend, Date minuend, long diffField) {
        long diff = minuend.getTime() - subtrahend.getTime();
        return diff / diffField;
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    private static String yearAndSeason(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }
}

