/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.ClassUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.Setting;
import com.xiaoleilu.hutool.exceptions.UtilException;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import java.util.Map;
import org.slf4j.Logger;

public class CronUtil {
    private static Logger log = Log.get();
    public static final String CRONTAB_CONFIG_PATH = "config/cron4j.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        crontabSetting = new Setting(cronSettingPath, "utf8", false);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        for (Map.Entry<String, String> entry : cronSetting.entrySet()) {
            String jobClass = entry.getKey();
            String pattern = entry.getValue();
            try {
                Runnable job = (Runnable)ClassUtil.newInstance(jobClass);
                CronUtil.schedule(pattern, job);
                log.info("Schedule [{} {}] added.", (Object)pattern, (Object)jobClass);
            }
            catch (Exception e) {
                Log.error(log, e, "Schedule [%s %s] add error!", pattern, jobClass);
            }
        }
    }

    public void remove(String schedulerId) {
        scheduler.deschedule(schedulerId);
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    public static synchronized void start() {
        if (null == crontabSetting) {
            CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void restart() {
        if (null != crontabSetting) {
            crontabSetting.reload();
        }
        if (scheduler.isStarted()) {
            scheduler.stop();
        }
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }
}

