/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.IoUtil;
import com.xiaoleilu.hutool.ReUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*?)\"");

    public static String encode(String content, String charset) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charset), e);
        }
        return encodeContent;
    }

    public static String decode(String content, String charset) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charset), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (HttpUtil.isUnknow(ip)) {
            ip = request.getRemoteAddr();
        }
        return HttpUtil.getMultistageReverseProxyIp(ip);
    }

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static String get(String urlString, String customCharset) throws IOException {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) throws IOException {
        return HttpRequest.post(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, String params) throws IOException {
        return HttpRequest.post(urlString).body(params).execute().body();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadString(String url, String customCharset) throws IOException {
        String string;
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            string = IoUtil.getString(in, customCharset);
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(in);
        return string;
    }

    public static String toParams(Map<String, Object> paramMap) {
        return CollectionUtil.join(paramMap.entrySet(), "&");
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StrUtil.isBlank(paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > 0) {
            paramsStr = StrUtil.subSuf(paramsStr, pathEndPos + 1);
        }
        paramsStr = HttpUtil.decode(paramsStr, charset);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        for (i = 0; i < paramsStr.length(); ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "");
        }
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form) {
        String queryString = HttpUtil.toParams(form);
        return HttpUtil.urlWithForm(url, queryString);
    }

    public static String urlWithForm(String url, String queryString) {
        if (StrUtil.isNotBlank(queryString)) {
            if (url.contains("?")) {
                url = url + "&" + queryString;
            }
            url = url + (url.endsWith("?") ? queryString : "?" + queryString);
        }
        return url;
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        String charset = conn.getContentEncoding();
        if (StrUtil.isBlank(charset)) {
            charset = ReUtil.get(CHARSET_PATTERN, conn.getContentType(), 1);
        }
        return charset;
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (HttpUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || Header.UNKNOW.toString().equalsIgnoreCase(checkString);
    }

    public static String getString(InputStream in, String charset, boolean isGetCharsetFromContent) throws IOException {
        StringBuilder content = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String charsetInContent;
            content.append(line).append('\n');
            if (!isGetCharsetFromContent || StrUtil.isBlank(charsetInContent = ReUtil.get(CHARSET_PATTERN, line, 1))) continue;
            charset = charsetInContent;
            reader = new BufferedReader(new InputStreamReader(in, charset));
            isGetCharsetFromContent = false;
        }
        return content.toString();
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }
}

