/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.NetUtil;
import com.xiaoleilu.hutool.Setting;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.NotInitedException;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;

public class MongoDS
implements Closeable {
    private static final Logger log = Log.get();
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private static final String GROUP_SEPRATER = ",";
    private static Map<String, MongoDS> dsMap = new HashMap<String, MongoDS>();
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    public static MongoDS getDS(String host, int port) {
        String key = host + ":" + port;
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(host, port);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(String ... groups) {
        String key = CollectionUtil.join(groups, GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Collection<String> groups) {
        return MongoDS.getDS(groups.toArray(new String[groups.size()]));
    }

    public static MongoDS getDS(Setting setting, String ... groups) {
        String key = setting.getSettingPath() + GROUP_SEPRATER + CollectionUtil.join(groups, GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(setting, groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Setting setting, Collection<String> groups) {
        return MongoDS.getDS(setting, groups.toArray(new String[groups.size()]));
    }

    public static void closeAll() {
        for (MongoDS ds : dsMap.values()) {
            ds.close();
        }
        dsMap.clear();
    }

    public MongoDS(String host, int port) {
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(Setting mongoSetting, String host, int port) {
        this.setting = mongoSetting;
        this.serverAddress = this.createServerAddress(host, port);
        this.initSingle();
    }

    public MongoDS(String ... groups) {
        this.groups = groups;
        this.init();
    }

    public MongoDS(Setting mongoSetting, String ... groups) {
        if (mongoSetting == null) {
            throw new UtilException("Mongo setting is null!");
        }
        this.setting = mongoSetting;
        this.groups = groups;
        this.init();
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
        } else {
            this.initSingle();
        }
    }

    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, "UTF-8", true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String group = "";
        if (this.serverAddress == null) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        try {
            this.mongo = new MongoClient(this.serverAddress, this.buildMongoClientOptions(group));
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Init MongoDB pool with connection to [{}] error!", this.serverAddress), e);
        }
        log.info("Init MongoDB pool with connection to [{}]", (Object)this.serverAddress);
    }

    public synchronized void initCloud() {
        if (this.groups == null || this.groups.length == 0) {
            throw new UtilException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, "utf8", true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        for (String group : this.groups) {
            addrList.add(this.createServerAddress(group));
        }
        try {
            this.mongo = new MongoClient(addrList, this.buildMongoClientOptions(""));
        }
        catch (Exception e) {
            log.error("Init MongoDB connection error!", (Throwable)e);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", addrList);
    }

    public void setSetting(Setting setting) {
        this.setting = setting;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoDatabase getDb(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        return this.getDb(dbName).getCollection(collectionName);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private ServerAddress createServerAddress(String group) {
        String tmpHost;
        if (this.setting == null) {
            throw new UtilException(StrUtil.format("Please indicate setting file or create default [{}], and define group [{}]", MONGO_CONFIG_PATH, group));
        }
        if (group == null) {
            group = "";
        }
        if (StrUtil.isBlank(tmpHost = this.setting.getString("host", group))) {
            throw new NotInitedException("Host name is empy of group: " + group);
        }
        int defaultPort = this.setting.getInt("port", group, 27017);
        return new ServerAddress(NetUtil.buildInetSocketAddress(tmpHost, defaultPort));
    }

    private ServerAddress createServerAddress(String host, int port) {
        return new ServerAddress(host, port);
    }

    private MongoClientOptions buildMongoClientOptions(String group) {
        return this.buildMongoClientOptions(MongoClientOptions.builder(), group).build();
    }

    private MongoClientOptions.Builder buildMongoClientOptions(MongoClientOptions.Builder builder, String group) {
        if (this.setting == null) {
            return builder;
        }
        group = group == null ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt(group + "connectionsPerHost");
        if (!StrUtil.isBlank(group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt("connectionsPerHost");
        }
        if (connectionsPerHost != null) {
            builder.connectionsPerHost(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", (Object)connectionsPerHost);
        }
        Integer threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt(group + "threadsAllowedToBlockForConnectionMultiplier");
        if (!StrUtil.isBlank(group) && threadsAllowedToBlockForConnectionMultiplier == null) {
            threadsAllowedToBlockForConnectionMultiplier = this.setting.getInt("threadsAllowedToBlockForConnectionMultiplier");
        }
        if (threadsAllowedToBlockForConnectionMultiplier != null) {
            builder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier.intValue());
            log.debug("MongoDB threadsAllowedToBlockForConnectionMultiplier: {}", (Object)threadsAllowedToBlockForConnectionMultiplier);
        }
        Integer connectTimeout = this.setting.getInt(group + "connectTimeout");
        if (!StrUtil.isBlank(group) && connectTimeout == null) {
            this.setting.getInt("connectTimeout");
        }
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout.intValue());
            log.debug("MongoDB connectTimeout: {}", (Object)connectTimeout);
        }
        Integer socketTimeout = this.setting.getInt(group + "socketTimeout");
        if (!StrUtil.isBlank(group) && socketTimeout == null) {
            this.setting.getInt("socketTimeout");
        }
        if (socketTimeout != null) {
            builder.socketTimeout(socketTimeout.intValue());
            log.debug("MongoDB socketTimeout: {}", (Object)socketTimeout);
        }
        Boolean socketKeepAlive = this.setting.getBool(group + "socketKeepAlive");
        if (!StrUtil.isBlank(group) && socketKeepAlive == null) {
            socketKeepAlive = this.setting.getBool("socketKeepAlive");
        }
        if (socketKeepAlive != null) {
            builder.socketKeepAlive(socketKeepAlive.booleanValue());
            log.debug("MongoDB socketKeepAlive: {}", (Object)socketKeepAlive);
        }
        return builder;
    }

    protected void finalize() throws Throwable {
        log.info("MongoDS is finalized!");
        this.close();
        super.finalize();
    }
}

