/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.Conver;
import com.xiaoleilu.hutool.InjectUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Entity
extends HashMap<String, Object> {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;

    public static Entity create(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity parse(T vo) {
        return Entity.create(null).fromVo(vo);
    }

    public Entity() {
    }

    public Entity(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Entity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public <T> Entity fillVo(T vo) {
        InjectUtil.injectFromMap(vo, this);
        return this;
    }

    public <T> T toVo(Class<T> clazz) {
        T vo;
        if (clazz == null) {
            throw new NullPointerException("Provided Class is null!");
        }
        try {
            vo = clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance Value Object [] error!", clazz.getName()));
        }
        InjectUtil.injectFromMap(vo, this);
        return vo;
    }

    public <T> Entity fromVo(T vo) {
        String tableName = vo.getClass().getSimpleName();
        tableName = StrUtil.lowerFirst(tableName);
        this.setTableName(tableName);
        this.putAll(InjectUtil.toMap(vo, false));
        return this;
    }

    public <T extends Entity> void removeEqual(T entity, String ... withoutNames) {
        HashSet<String> withoutSet = new HashSet<String>();
        for (String name : withoutNames) {
            withoutSet.add(name);
        }
        for (Map.Entry entry : entity.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Entity set(String attr, Object value) {
        super.put(attr, value);
        return this;
    }

    public Entity setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        return Conver.toStr(this.get(attr), null);
    }

    public Integer getInt(String attr) {
        return Conver.toInt(this.get(attr), null);
    }

    public Long getLong(String attr) {
        return Conver.toLong(this.get(attr), null);
    }

    public Float getFloat(String attr) {
        return Conver.toFloat(this.get(attr), null);
    }

    public Boolean getBool(String attr) {
        return Conver.toBool(this.get(attr), null);
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    public BigDecimal getBigDecimal(String attr) {
        return this.get(attr, null);
    }

    public BigInteger getBigInteger(String attr) {
        return this.get(attr, null);
    }
}

