/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.FileUtil;
import com.xiaoleilu.hutool.IoUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public class ZipUtil {
    private static final Logger log = Log.get();

    public static void zip(String srcPath, String zipPath) throws Exception {
        ZipUtil.zip(srcPath, zipPath, false);
    }

    public static void zip(String srcPath, String zipPath, boolean withSrcDir) throws Exception {
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.touch(zipPath);
        ZipUtil.validateFile(srcFile, zipFile);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new CheckedOutputStream(FileUtil.getOutputStream(zipFile), new CRC32()));
            String srcRootDir = srcPath;
            if (srcFile.isFile() || withSrcDir) {
                srcRootDir = srcFile.getParent();
            }
            ZipUtil.zip(srcRootDir, srcFile, out);
            out.flush();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(out);
    }

    public static void unzip(String zipFilePath, String outFileDir) throws IOException {
        ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir(outFileDir));
    }

    public static void unzip(File zipFile, File outFile) throws IOException {
        ZipFile zipFileObj = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> em = zipFileObj.entries();
        ZipEntry zipEntry = null;
        File outItemFile = null;
        while (em.hasMoreElements()) {
            zipEntry = em.nextElement();
            outItemFile = new File(outFile, zipEntry.getName());
            log.debug("UNZIP {}", (Object)outItemFile.getPath());
            if (zipEntry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileUtil.touch(outItemFile);
            ZipUtil.copy(zipFileObj, zipEntry, outItemFile);
        }
        FileUtil.close(zipFileObj);
    }

    private static void zip(String srcRootDir, File file, ZipOutputStream out) {
        block7: {
            block6: {
                if (file == null) {
                    return;
                }
                if (!file.isFile()) break block6;
                String subPath = FileUtil.subPath(srcRootDir, file);
                log.debug("ZIP {}", (Object)subPath);
                BufferedInputStream in = null;
                try {
                    out.putNextEntry(new ZipEntry(subPath));
                    in = FileUtil.getInputStream(file);
                    IoUtil.copy(in, out);
                }
                catch (IOException e) {
                    try {
                        throw new UtilException(e);
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(in);
                        ZipUtil.closeEntry(out);
                        throw throwable;
                    }
                }
                FileUtil.close(in);
                ZipUtil.closeEntry(out);
                break block7;
            }
            for (File childFile : file.listFiles()) {
                ZipUtil.zip(srcRootDir, childFile, out);
            }
        }
    }

    private static void validateFile(File srcFile, File zipFile) {
        if (!srcFile.exists()) {
            throw new UtilException(StrUtil.format("File [{}] not exist!", srcFile.getAbsolutePath()));
        }
        try {
            if (srcFile.isDirectory() && zipFile.getCanonicalPath().contains(srcFile.getCanonicalPath())) {
                throw new UtilException("[zipPath] must not be the child directory of [srcPath]!");
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IOException {
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            out = FileUtil.getOutputStream(outItemFile);
            IoUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(out);
        FileUtil.close(in);
    }
}

